/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.osc.components;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.praxislive.base.AbstractProperty;
import org.praxislive.base.AbstractRoot;
import org.praxislive.base.AbstractRootContainer;
import org.praxislive.core.Clock;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.Control;
import org.praxislive.core.Info;
import org.praxislive.core.Lookup;
import org.praxislive.core.Value;
import org.praxislive.core.protocols.ComponentProtocol;
import org.praxislive.core.protocols.ContainerProtocol;
import org.praxislive.core.protocols.StartableProtocol;
import org.praxislive.core.types.PNumber;
import org.praxislive.core.types.PString;
import org.praxislive.internal.osc.OSCListener;
import org.praxislive.internal.osc.OSCMessage;
import org.praxislive.internal.osc.OSCServer;
import org.praxislive.osc.components.OSCContext;

public class OSCRoot
extends AbstractRootContainer {
    private static final Logger LOG = Logger.getLogger(OSCRoot.class.getName());
    private static final int DEFAULT_PORT = 1234;
    private static final String DEFAULT_PROTOCOL = "udp";
    private final OSCContext context = new OSCContext();
    private final BlockingQueue<OSCMessage> messages = new LinkedBlockingQueue<OSCMessage>();
    private final ComponentInfo info;
    private int port = 1234;
    private Lookup lookup;
    private OSCServer server;
    private OSCMessage lastMessage;

    public OSCRoot() {
        this.registerControl("port", (Control)new PortBinding());
        this.registerControl("last-message", (Control)new LastMessageBinding());
        this.info = Info.component(cmp -> cmp.merge(ComponentProtocol.API_INFO).merge(ContainerProtocol.API_INFO).merge(StartableProtocol.API_INFO).control("port", c -> c.property().defaultValue((Value)PNumber.of((int)1234)).input(a -> a.number().min(1.0).max(65535.0))).control("last-message", c -> c.readOnlyProperty().output(PString.class)));
    }

    public ComponentInfo getInfo() {
        return this.info;
    }

    public Lookup getLookup() {
        if (this.lookup == null) {
            this.lookup = Lookup.of((Lookup)super.getLookup(), (Object[])new Object[]{this.context});
        }
        return this.lookup;
    }

    protected void starting() {
        try {
            this.lastMessage = null;
            this.server = OSCServer.newUsing((String)DEFAULT_PROTOCOL, (int)this.port);
            this.server.addOSCListener((OSCListener)new OSCListenerImpl());
            this.server.start();
            OSCRunnable r = new OSCRunnable(this.getRootHub().getClock());
            this.attachDelegate(r);
            r.start();
        }
        catch (IOException ex) {
            Logger.getLogger(OSCRoot.class.getName()).log(Level.SEVERE, null, ex);
            this.setIdle();
        }
    }

    protected void stopping() {
        this.terminateServer();
    }

    protected void terminating() {
        this.terminateServer();
    }

    private void terminateServer() {
        if (this.server == null) {
            return;
        }
        try {
            this.server.stop();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.server.dispose();
        this.server = null;
        this.messages.clear();
    }

    private class OSCRunnable
    extends AbstractRoot.Delegate {
        private final Clock clock;

        private OSCRunnable(Clock clock) {
            super((AbstractRoot)OSCRoot.this);
            this.clock = clock;
        }

        private void run() {
            while (OSCRoot.this.getState() == AbstractRoot.State.ACTIVE_RUNNING) {
                long time = this.clock.getTime();
                this.doUpdate(time);
                OSCMessage msg = null;
                try {
                    msg = OSCRoot.this.messages.poll(50L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                while (msg != null) {
                    LOG.log(Level.FINEST, "Handling message to {0}", msg.getName());
                    OSCRoot.this.lastMessage = msg;
                    OSCRoot.this.context.dispatch(msg, time);
                    msg = (OSCMessage)OSCRoot.this.messages.poll();
                }
                if (OSCRoot.this.server == null || OSCRoot.this.server.isActive()) continue;
                OSCRoot.this.setIdle();
            }
            OSCRoot.this.detachDelegate(this);
        }

        private void start() {
            Thread t = this.getThreadFactory().newThread(this::run);
            t.start();
        }
    }

    private class OSCListenerImpl
    implements OSCListener {
        private OSCListenerImpl() {
        }

        public void messageReceived(OSCMessage oscm, SocketAddress sa, long l) {
            OSCRoot.this.messages.add(oscm);
        }
    }

    private class LastMessageBinding
    extends AbstractProperty {
        private LastMessageBinding() {
        }

        public Value get() {
            if (OSCRoot.this.lastMessage != null) {
                StringBuilder sb = new StringBuilder(OSCRoot.this.lastMessage.getName());
                for (int i = 0; i < OSCRoot.this.lastMessage.getArgCount(); ++i) {
                    sb.append(" ");
                    sb.append(OSCRoot.this.lastMessage.getArg(i));
                }
                return PString.of((Object)sb);
            }
            return PString.EMPTY;
        }

        protected void set(long time, Value arg) throws Exception {
            throw new UnsupportedOperationException();
        }
    }

    private class PortBinding
    extends AbstractProperty {
        private PortBinding() {
        }

        public void set(long time, Value value) {
            if (OSCRoot.this.getState() == AbstractRoot.State.ACTIVE_RUNNING) {
                throw new UnsupportedOperationException("Can't set port while running");
            }
            OSCRoot.this.port = PNumber.from((Value)value).map(PNumber::toIntValue).orElseThrow(IllegalArgumentException::new);
        }

        public Value get() {
            return PNumber.of((int)OSCRoot.this.port);
        }
    }
}

