/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.project;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedMap;
import java.util.SequencedSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ComponentType;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.OrderedMap;
import org.praxislive.core.OrderedSet;
import org.praxislive.core.Value;
import org.praxislive.project.GraphElement;

public final class GraphBuilder {
    private GraphBuilder() {
    }

    public static Component component(ComponentType type) {
        return new Component(type);
    }

    public static Component component(GraphElement.Component component) {
        return new Component(component);
    }

    public static Root root(String id, ComponentType type) {
        return new Root(id, type);
    }

    public static Root root(GraphElement.Root root) {
        return new Root(root);
    }

    public static Root syntheticRoot() {
        return new Root("", GraphElement.Root.SYNTHETIC);
    }

    public static final class Component
    extends Base<Component> {
        private Component(ComponentType type) {
            super(type);
        }

        private Component(GraphElement.Component component) {
            super(component);
        }

        public GraphElement.Component build() {
            return GraphElement.component(this.type, this.comments, this.properties, this.children, this.connections);
        }
    }

    public static final class Root
    extends Base<Root> {
        private final String id;
        private final List<GraphElement.Command> commands;

        private Root(String id, ComponentType type) {
            super(type);
            this.id = id;
            this.commands = new ArrayList<GraphElement.Command>();
        }

        private Root(GraphElement.Root root) {
            super(root);
            this.id = root.id();
            this.commands = new ArrayList<GraphElement.Command>(root.commands());
        }

        public Root command(GraphElement.Command command) {
            this.commands.add(Objects.requireNonNull(command));
            return this;
        }

        public Root command(String command) {
            return this.command(GraphElement.command(command));
        }

        public Root clearCommands() {
            this.commands.clear();
            return this;
        }

        @Override
        public Root property(String id, GraphElement.Property property) {
            if (this.isSynthetic()) {
                throw new IllegalStateException("Synthetic roots cannot have properties.");
            }
            return (Root)super.property(id, property);
        }

        public Root transformCommands(Function<Stream<GraphElement.Command>, List<GraphElement.Command>> transform) {
            List<GraphElement.Command> transformed = transform.apply(this.commands.stream());
            this.clearCommands();
            transformed.forEach(c -> this.command((GraphElement.Command)c));
            return this;
        }

        public List<GraphElement.Command> commands() {
            return List.copyOf(this.commands);
        }

        public String id() {
            return this.id;
        }

        public boolean isSynthetic() {
            return this.id.isEmpty();
        }

        public GraphElement.Root build() {
            return GraphElement.root(this.id, this.type, this.comments, this.commands, this.properties, this.children, this.connections);
        }
    }

    public static abstract sealed class Base<B extends Base<B>>
    permits Component, Root {
        final ComponentType type;
        final List<GraphElement.Comment> comments;
        final SequencedMap<String, GraphElement.Property> properties;
        final SequencedMap<String, GraphElement.Component> children;
        final SequencedSet<GraphElement.Connection> connections;

        private Base(ComponentType type) {
            this.type = Objects.requireNonNull(type);
            this.comments = new ArrayList<GraphElement.Comment>();
            this.properties = new LinkedHashMap<String, GraphElement.Property>();
            this.children = new LinkedHashMap<String, GraphElement.Component>();
            this.connections = new LinkedHashSet<GraphElement.Connection>();
        }

        private Base(GraphElement.Component component) {
            this(component.type());
            this.comments.addAll(component.comments());
            this.properties.putAll(component.properties());
            this.children.putAll(component.children());
            this.connections.addAll(component.connections());
        }

        public B child(String id, GraphElement.Component child) {
            if (!ComponentAddress.isValidID((String)id)) {
                throw new IllegalArgumentException(id + " is not a valid child ID");
            }
            this.children.put(id, Objects.requireNonNull(child));
            return (B)this;
        }

        public B child(String id, ComponentType type, Consumer<Component> constructor) {
            Component childBuilder = new Component(type);
            constructor.accept(childBuilder);
            return this.child(id, childBuilder.build());
        }

        public B comment(String text) {
            return this.comment(GraphElement.comment(text));
        }

        public B comment(GraphElement.Comment comment) {
            this.comments.add(Objects.requireNonNull(comment));
            return (B)this;
        }

        public B connection(String sourceComponent, String sourcePort, String targetComponent, String targetPort) {
            return this.connection(GraphElement.connection(sourceComponent, sourcePort, targetComponent, targetPort));
        }

        public B connection(GraphElement.Connection connection) {
            this.connections.add(Objects.requireNonNull(connection));
            return (B)this;
        }

        public B property(String id, Value value) {
            return this.property(id, GraphElement.property(value));
        }

        public B property(String id, GraphElement.Property property) {
            if (!ControlAddress.isValidID((String)id)) {
                throw new IllegalArgumentException(id + " is not a valid property ID");
            }
            this.properties.put(id, Objects.requireNonNull(property));
            return (B)this;
        }

        public B clearChildren() {
            this.children.clear();
            return (B)this;
        }

        public B clearComments() {
            this.comments.clear();
            return (B)this;
        }

        public B clearConnections() {
            this.connections.clear();
            return (B)this;
        }

        public B clearProperties() {
            this.properties.clear();
            return (B)this;
        }

        public B transformChildren(Function<Stream<Map.Entry<String, GraphElement.Component>>, List<Map.Entry<String, GraphElement.Component>>> transform) {
            List<Map.Entry<String, GraphElement.Component>> transformed = transform.apply(this.children.entrySet().stream());
            this.clearChildren();
            transformed.forEach(c -> this.child((String)c.getKey(), (GraphElement.Component)c.getValue()));
            return (B)this;
        }

        public B transformComments(Function<Stream<GraphElement.Comment>, List<GraphElement.Comment>> transform) {
            List<GraphElement.Comment> transformed = transform.apply(this.comments.stream());
            this.clearComments();
            transformed.forEach(c -> this.comment((GraphElement.Comment)c));
            return (B)this;
        }

        public B transformConnections(Function<Stream<GraphElement.Connection>, List<GraphElement.Connection>> transform) {
            List<GraphElement.Connection> transformed = transform.apply(this.connections.stream());
            this.clearConnections();
            transformed.forEach(c -> this.connection((GraphElement.Connection)c));
            return (B)this;
        }

        public B transformProperties(Function<Stream<Map.Entry<String, GraphElement.Property>>, List<Map.Entry<String, GraphElement.Property>>> transform) {
            List<Map.Entry<String, GraphElement.Property>> transformed = transform.apply(this.properties.entrySet().stream());
            this.clearProperties();
            transformed.forEach(p -> this.property((String)p.getKey(), (GraphElement.Property)p.getValue()));
            return (B)this;
        }

        public ComponentType type() {
            return this.type;
        }

        public List<GraphElement.Comment> comments() {
            return List.copyOf(this.comments);
        }

        public SequencedMap<String, GraphElement.Property> properties() {
            return OrderedMap.copyOf(this.properties);
        }

        public SequencedMap<String, GraphElement.Component> children() {
            return OrderedMap.copyOf(this.children);
        }

        public SequencedSet<GraphElement.Connection> connections() {
            return OrderedSet.copyOf(this.connections);
        }
    }
}

