/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.project;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedMap;
import java.util.SequencedSet;
import java.util.Set;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ComponentType;
import org.praxislive.core.OrderedMap;
import org.praxislive.core.OrderedSet;
import org.praxislive.core.Value;
import org.praxislive.core.syntax.Token;
import org.praxislive.core.syntax.Tokenizer;

public abstract sealed class GraphElement {
    private GraphElement() {
    }

    public static Command command(String command) {
        Iterator itr = new Tokenizer((CharSequence)command).iterator();
        ArrayList<Token> tokens = new ArrayList<Token>();
        while (itr.hasNext()) {
            Token token = (Token)itr.next();
            if (tokens.isEmpty() && token.getType() != Token.Type.PLAIN) {
                throw new IllegalArgumentException("First token of a command must be plain");
            }
            if (token.getType() == Token.Type.COMMENT) {
                throw new IllegalArgumentException("Invalid command - contains a comment");
            }
            if (token.getType() == Token.Type.EOL) break;
            tokens.add(token);
        }
        if (itr.hasNext()) {
            throw new IllegalArgumentException("Invalid command - tokens found after EOL");
        }
        return new Command(command, tokens);
    }

    public static Comment comment(String text) {
        return new Comment(text);
    }

    public static Connection connection(String sourceComponent, String sourcePort, String targetComponent, String targetPort) {
        return new Connection(sourceComponent, sourcePort, targetComponent, targetPort);
    }

    public static Property property(Value value) {
        return new Property(value);
    }

    static Component component(ComponentType type, List<Comment> comments, Map<String, Property> properties, Map<String, Component> children, Set<Connection> connections) {
        return new Component(type, comments, properties, children, connections);
    }

    static Root root(String id, ComponentType type, List<Comment> comments, List<Command> commands, Map<String, Property> properties, Map<String, Component> children, Set<Connection> connections) {
        return new Root(id, type, comments, commands, properties, children, connections);
    }

    public static final class Command
    extends GraphElement {
        private final String command;
        private final List<Token> tokens;

        Command(String command, List<Token> tokens) {
            this.command = Objects.requireNonNull(command);
            this.tokens = List.copyOf(tokens);
        }

        public String command() {
            return this.command;
        }

        public List<Token> tokens() {
            return this.tokens;
        }

        public int hashCode() {
            return Objects.hashCode(this.command);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (obj == this) return true;
            if (!(obj instanceof Command)) return false;
            Command c = (Command)obj;
            if (!Objects.equals(this.command, c.command)) return false;
            return true;
        }

        public String toString() {
            return "Command{command=" + this.command + "}";
        }
    }

    public static final class Comment
    extends GraphElement {
        private final String text;

        private Comment(String text) {
            this.text = Objects.requireNonNull(text);
        }

        public String text() {
            return this.text;
        }

        public int hashCode() {
            return Objects.hashCode(this.text);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (obj == this) return true;
            if (!(obj instanceof Comment)) return false;
            Comment c = (Comment)obj;
            if (!Objects.equals(this.text, c.text)) return false;
            return true;
        }

        public String toString() {
            return "Comment{text=" + this.text + "}";
        }
    }

    public static final class Connection
    extends GraphElement {
        private final org.praxislive.core.Connection value;

        private Connection(String sourceComponent, String sourcePort, String targetComponent, String targetPort) {
            this.value = org.praxislive.core.Connection.of((String)sourceComponent, (String)sourcePort, (String)targetComponent, (String)targetPort);
        }

        public String sourceComponent() {
            return this.value.sourceComponent();
        }

        public String sourcePort() {
            return this.value.sourcePort();
        }

        public String targetComponent() {
            return this.value.targetComponent();
        }

        public String targetPort() {
            return this.value.targetPort();
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (obj == this) return true;
            if (!(obj instanceof Connection)) return false;
            Connection c = (Connection)obj;
            if (!Objects.equals(this.value, c.value)) return false;
            return true;
        }

        public String toString() {
            return "Connection{sourceComponent=" + this.sourceComponent() + ", sourcePort=" + this.sourcePort() + ", targetComponent=" + this.targetComponent() + ", targetPort=" + this.targetPort() + "}";
        }
    }

    public static final class Property
    extends GraphElement {
        private final Value value;

        private Property(Value value) {
            this.value = Objects.requireNonNull(value);
        }

        public Value value() {
            return this.value;
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (obj == this) return true;
            if (!(obj instanceof Property)) return false;
            Property p = (Property)obj;
            if (!Objects.equals(this.value, p.value)) return false;
            return true;
        }

        public String toString() {
            return "Property{value=" + String.valueOf(this.value) + "}";
        }
    }

    public static sealed class Component
    extends GraphElement
    permits Root {
        private final ComponentType type;
        private final List<Comment> comments;
        private final OrderedMap<String, Property> properties;
        private final OrderedMap<String, Component> children;
        private final OrderedSet<Connection> connections;

        private Component(ComponentType type, List<Comment> comments, Map<String, Property> properties, Map<String, Component> children, Set<Connection> connections) {
            this.type = Objects.requireNonNull(type);
            this.comments = List.copyOf(comments);
            this.properties = OrderedMap.copyOf(properties);
            this.children = OrderedMap.copyOf(children);
            this.connections = OrderedSet.copyOf(connections);
        }

        public ComponentType type() {
            return this.type;
        }

        public List<Comment> comments() {
            return this.comments;
        }

        public SequencedMap<String, Property> properties() {
            return this.properties;
        }

        public SequencedMap<String, Component> children() {
            return this.children;
        }

        public SequencedSet<Connection> connections() {
            return this.connections;
        }

        public int hashCode() {
            return Objects.hash(this.type, this.comments, this.properties, this.children, this.connections);
        }

        public boolean equals(Object obj) {
            Component c;
            return obj == this || obj instanceof Component && (c = (Component)obj).getClass() == Component.class && Objects.equals(this.type, c.type) && Objects.equals(this.comments, c.comments) && Objects.equals(this.properties, c.properties) && Objects.equals(this.children, c.children) && Objects.equals(this.connections, c.connections);
        }

        public String toString() {
            return "Component{type=" + String.valueOf(this.type) + ",\ncomments=" + String.valueOf(this.comments) + ",\nproperties=" + String.valueOf(this.properties) + ",\nchildren=" + String.valueOf(this.children) + ",\nconnections=" + String.valueOf(this.connections) + "}";
        }
    }

    public static final class Root
    extends Component {
        static final ComponentType SYNTHETIC = ComponentType.of((String)"root:synthetic");
        private final String id;
        private final List<Command> commands;

        private Root(String id, ComponentType type, List<Comment> comments, List<Command> commands, Map<String, Property> properties, Map<String, Component> children, Set<Connection> connections) {
            super(type, comments, properties, children, connections);
            if (id.isEmpty()) {
                if (!SYNTHETIC.equals((Object)type)) {
                    throw new IllegalArgumentException("Invalid type for synthetic root");
                }
                this.id = "";
            } else {
                if (!ComponentAddress.isValidID((String)id)) {
                    throw new IllegalArgumentException("Invalid root ID");
                }
                this.id = id;
            }
            this.commands = List.copyOf(commands);
        }

        public String id() {
            return this.id;
        }

        public List<Command> commands() {
            return this.commands;
        }

        public boolean isSynthetic() {
            return this.id.isEmpty();
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.id, this.commands, this.type(), this.comments(), this.properties(), this.children(), this.connections());
        }

        @Override
        public boolean equals(Object obj) {
            Root r;
            return obj == this || obj instanceof Root && (r = (Root)obj).getClass() == Root.class && Objects.equals(this.id, r.id) && Objects.equals(this.commands, r.commands) && Objects.equals(this.type(), r.type()) && Objects.equals(this.comments(), r.comments()) && Objects.equals(this.properties(), r.properties()) && Objects.equals(this.children(), r.children()) && Objects.equals(this.connections(), r.connections());
        }

        @Override
        public String toString() {
            return "Root{id=" + this.id + ",\ncommands=" + String.valueOf(this.commands) + "type=" + String.valueOf(this.type()) + ",\ncomments=" + String.valueOf(this.comments()) + ",\nproperties=" + String.valueOf(this.properties()) + ",\nchildren=" + String.valueOf(this.children()) + ",\nconnections=" + String.valueOf(this.connections()) + "}";
        }
    }
}

