/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.project;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.praxislive.core.ArgumentInfo;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.ComponentType;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.ControlInfo;
import org.praxislive.core.Value;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PMap;
import org.praxislive.project.GraphBuilder;
import org.praxislive.project.GraphElement;
import org.praxislive.project.GraphParser;
import org.praxislive.project.GraphWriter;
import org.praxislive.project.ModelUtils;
import org.praxislive.project.ParseException;

public final class GraphModel {
    private final GraphElement.Root root;
    private final URI context;

    private GraphModel(GraphElement.Root root, URI context) {
        this.root = root;
        this.context = context;
    }

    public GraphElement.Root root() {
        return this.root;
    }

    public Optional<URI> context() {
        return Optional.ofNullable(this.context);
    }

    public GraphModel withContext(URI context) {
        return new GraphModel(this.root, ModelUtils.validateContext(context));
    }

    public GraphModel withRename(String id) {
        if (this.root.isSynthetic()) {
            throw new IllegalStateException("Cannot rename synthetic root");
        }
        GraphBuilder.Root builder = GraphBuilder.root(id, this.root.type());
        this.root.comments().forEach(builder::comment);
        this.root.commands().forEach(builder::command);
        this.root.properties().forEach(builder::property);
        this.root.children().forEach(builder::child);
        this.root.connections().forEach(builder::connection);
        return new GraphModel(builder.build(), this.context);
    }

    public GraphModel withTransform(Consumer<GraphBuilder.Root> transform) {
        GraphBuilder.Root builder = GraphBuilder.root(this.root);
        transform.accept(builder);
        return new GraphModel(builder.build(), this.context);
    }

    public void write(Appendable target) throws IOException {
        GraphWriter.write(this, target);
    }

    public String writeToString() {
        StringBuilder sb = new StringBuilder();
        try {
            this.write(sb);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof GraphModel)) return false;
        GraphModel other = (GraphModel)obj;
        if (!Objects.equals(this.root, other.root)) return false;
        if (!Objects.equals(this.context, other.context)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.root, this.context);
    }

    public String toString() {
        return "GraphModel {\n  Context : " + String.valueOf(this.context) + "\n  Graph :\n" + this.writeToString().indent(4) + "\n}";
    }

    public static GraphModel fromSerializedComponent(String componentID, PMap data) {
        GraphElement.Root root = ((GraphBuilder.Root)GraphBuilder.syntheticRoot().child(componentID, GraphModel.typeFromData(data), cmp -> GraphModel.buildSerializedComponent(cmp, data, true, null))).build();
        return new GraphModel(root, null);
    }

    public static GraphModel fromSerializedRoot(String rootID, PMap data) {
        GraphBuilder.Root rootBuilder = GraphBuilder.root(rootID, GraphModel.typeFromData(data));
        GraphModel.buildSerializedComponent(rootBuilder, data, true, null);
        return new GraphModel(rootBuilder.build(), null);
    }

    public static GraphModel fromSerializedSubgraph(PMap data) {
        return GraphModel.fromSerializedSubgraph(data, null);
    }

    public static GraphModel fromSerializedSubgraph(PMap data, Predicate<String> filter) {
        GraphBuilder.Root rootBuilder = GraphBuilder.syntheticRoot();
        GraphModel.buildSerializedComponent(rootBuilder, data, false, filter);
        return new GraphModel(rootBuilder.build(), null);
    }

    public static GraphModel of(GraphElement.Root root) {
        return new GraphModel(Objects.requireNonNull(root), null);
    }

    public static GraphModel of(GraphElement.Root root, URI context) {
        return new GraphModel(Objects.requireNonNull(root), ModelUtils.validateContext(Objects.requireNonNull(context)));
    }

    public static GraphModel parse(String graph) throws ParseException {
        GraphElement.Root root = GraphParser.parse(graph);
        return new GraphModel(root, null);
    }

    public static GraphModel parse(URI context, String graph) throws ParseException {
        GraphElement.Root root = GraphParser.parse(ModelUtils.validateContext(context), graph);
        return new GraphModel(root, context);
    }

    public static GraphModel parseSubgraph(String graph) throws ParseException {
        GraphElement.Root root = GraphParser.parseSubgraph(graph);
        return new GraphModel(root, null);
    }

    public static GraphModel parseSubgraph(URI context, String graph) throws ParseException {
        GraphElement.Root root = GraphParser.parseSubgraph(ModelUtils.validateContext(context), graph);
        return new GraphModel(root, context);
    }

    private static void buildSerializedComponent(GraphBuilder.Base<?> component, PMap data, boolean includeProperties, Predicate<String> filter) {
        ComponentInfo info = Optional.ofNullable(data.get("%info")).flatMap(ComponentInfo::from).orElse(null);
        data.asMap().forEach((key, value) -> {
            if (key.startsWith("@")) {
                String id = key.substring(1);
                if (filter == null || filter.test(id)) {
                    PMap childData = (PMap)PMap.from((Value)value).orElseThrow(IllegalArgumentException::new);
                    component.child(id, GraphModel.typeFromData(childData), cmp -> GraphModel.buildSerializedComponent(cmp, childData, true, null));
                }
            } else if (key.startsWith("%")) {
                if ("%connections".equals(key)) {
                    GraphModel.buildConnectionsList(value, filter).forEach(c -> component.connection((GraphElement.Connection)c));
                }
            } else if (includeProperties && ControlAddress.isValidID((String)key)) {
                component.property((String)key, GraphModel.coerceTypeFromInfo(key, info, value));
            }
        });
    }

    private static ComponentType typeFromData(PMap data) {
        return (ComponentType)Optional.ofNullable(data.get("%type")).flatMap(ComponentType::from).orElseThrow(() -> new IllegalArgumentException("No type in data map"));
    }

    private static Value coerceTypeFromInfo(String id, ComponentInfo info, Value value) {
        Value coerced;
        Value.Type type = Optional.ofNullable(info.controlInfo(id)).map(ControlInfo::inputs).filter(ins -> !ins.isEmpty()).map(ins -> (ArgumentInfo)ins.get(0)).flatMap(in -> Value.Type.fromName((String)in.argumentType())).orElse(null);
        if (type != null && (coerced = (Value)((Optional)type.converter().apply(value)).orElse(null)) != null) {
            return coerced;
        }
        return value;
    }

    private static List<GraphElement.Connection> buildConnectionsList(Value connections, Predicate<String> filter) {
        return ((PArray)PArray.from((Value)connections).orElseThrow(() -> new IllegalArgumentException("Connections is not an array : " + String.valueOf(connections)))).stream().map(connection -> {
            PArray arr = PArray.from((Value)connection).filter(a -> a.size() == 4).orElseThrow(() -> new IllegalArgumentException("Not a valid connection : " + String.valueOf(connection)));
            String sourceComponent = arr.get(0).toString();
            String sourcePort = arr.get(1).toString();
            String targetComponent = arr.get(2).toString();
            String targetPort = arr.get(3).toString();
            return GraphElement.connection(sourceComponent, sourcePort, targetComponent, targetPort);
        }).filter(c -> filter == null ? true : filter.test(c.sourceComponent()) && filter.test(c.targetComponent())).toList();
    }
}

