/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.project;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ComponentType;
import org.praxislive.core.PortAddress;
import org.praxislive.core.Value;
import org.praxislive.core.syntax.Token;
import org.praxislive.core.syntax.Tokenizer;
import org.praxislive.project.GraphBuilder;
import org.praxislive.project.GraphElement;
import org.praxislive.project.ParseException;
import org.praxislive.project.SyntaxUtils;

class GraphParser {
    private static final String AT = "@";
    private static final String CONNECT = "~";
    private static final String PROPERTY_PREFIX = ".";
    private static final String RELATIVE_ADDRESS_PREFIX = "./";
    private final String script;
    private final boolean subgraph;
    private final URI context;

    private GraphParser(String script, boolean subgraph, URI context) {
        this.script = script;
        this.subgraph = subgraph;
        this.context = context;
    }

    private GraphElement.Root doParse() throws ParseException {
        if (this.subgraph) {
            return this.parseSubGraph();
        }
        return this.parseFullGraph();
    }

    private GraphElement.Root parseFullGraph() throws ParseException {
        try {
            GraphBuilder.Root root = null;
            Iterator tokens = new Tokenizer((CharSequence)this.script).iterator();
            ArrayList<GraphElement.Command> commands = new ArrayList<GraphElement.Command>();
            while (tokens.hasNext()) {
                Token token = (Token)tokens.next();
                Token.Type type = token.getType();
                if (type == Token.Type.COMMENT || type == Token.Type.EOL || type != Token.Type.PLAIN) continue;
                if (AT.equals(token.getText())) {
                    root = this.parseRoot(GraphParser.tokensToEOL(tokens));
                    break;
                }
                List<Token> toEOL = GraphParser.tokensToEOL(tokens);
                commands.add(GraphElement.command(this.script.substring(token.getStartIndex(), toEOL.isEmpty() ? token.getEndIndex() : toEOL.getLast().getEndIndex())));
            }
            if (root == null) {
                throw new ParseException("No root element found");
            }
            while (tokens.hasNext()) {
                Token.Type type = ((Token)tokens.next()).getType();
                if (type == Token.Type.COMMENT || type == Token.Type.EOL) continue;
                throw new ParseException("Unexpected content found after root element");
            }
            commands.forEach(root::command);
            return root.build();
        }
        catch (ParseException pex) {
            throw pex;
        }
        catch (Exception ex) {
            throw new ParseException(ex);
        }
    }

    private GraphElement.Root parseSubGraph() throws ParseException {
        try {
            GraphBuilder.Root root = GraphBuilder.syntheticRoot();
            this.parseComponentBody(root, this.script);
            return root.build();
        }
        catch (Exception ex) {
            throw new ParseException(ex);
        }
    }

    private static List<Token> tokensToEOL(Iterator<Token> tokens) {
        Token t;
        ArrayList<Token> tks = new ArrayList<Token>();
        while (tokens.hasNext() && (t = tokens.next()).getType() != Token.Type.EOL) {
            tks.add(t);
        }
        return tks;
    }

    private GraphBuilder.Root parseRoot(List<Token> tokens) {
        ComponentAddress address;
        if (tokens.size() < 2 || tokens.size() > 3) {
            throw new IllegalArgumentException("Unexpected number of tokens in parseComponent");
        }
        Token t = tokens.get(0);
        if (t.getType() == Token.Type.PLAIN) {
            address = ComponentAddress.of((String)t.getText());
            if (address.depth() != 1) {
                throw new IllegalArgumentException("Invalid root address " + String.valueOf(address));
            }
        } else {
            throw new IllegalArgumentException("No root address found.");
        }
        String id = address.componentID();
        t = tokens.get(1);
        if (t.getType() != Token.Type.PLAIN) {
            throw new IllegalArgumentException("No root type found.");
        }
        ComponentType type = ComponentType.of((String)t.getText());
        GraphBuilder.Root root = GraphBuilder.root(id, type);
        if (tokens.size() == 3) {
            t = tokens.get(2);
            if (t.getType() != Token.Type.BRACED) {
                throw new IllegalArgumentException("Invalid token at end of component line : " + String.valueOf(tokens));
            }
            this.parseComponentBody(root, t.getText());
        }
        return root;
    }

    private void parseComponent(GraphBuilder.Base<?> parent, List<Token> tokens) {
        if (tokens.size() < 2 || tokens.size() > 3) {
            throw new IllegalArgumentException("Unexpected number of tokens in parseComponent");
        }
        String id = null;
        ComponentType type = null;
        Token t = tokens.get(0);
        if (t.getType() == Token.Type.PLAIN && t.getText().startsWith(RELATIVE_ADDRESS_PREFIX)) {
            id = t.getText().substring(RELATIVE_ADDRESS_PREFIX.length());
        }
        if ((t = tokens.get(1)).getType() == Token.Type.PLAIN) {
            type = ComponentType.of((String)t.getText());
        }
        if (id == null || type == null) {
            throw new IllegalArgumentException("Invalid component creation line : " + String.valueOf(tokens));
        }
        GraphBuilder.Component child = GraphBuilder.component(type);
        if (tokens.size() == 3) {
            t = tokens.get(2);
            if (t.getType() != Token.Type.BRACED) {
                throw new IllegalArgumentException("Invalid token at end of component line : " + String.valueOf(tokens));
            }
            this.parseComponentBody(child, t.getText());
        }
        parent.child(id, child.build());
    }

    private void parseComponentBody(GraphBuilder.Base<?> component, String body) {
        GraphBuilder.Root r;
        if (body == null || body.trim().isEmpty()) {
            return;
        }
        boolean allowCommands = component instanceof GraphBuilder.Root && (r = (GraphBuilder.Root)component).isSynthetic();
        Iterator tokens = new Tokenizer((CharSequence)body).iterator();
        block5: while (tokens.hasNext()) {
            Token token = (Token)tokens.next();
            String txt = token.getText();
            switch (token.getType()) {
                case COMMENT: {
                    component.comment(SyntaxUtils.unescapeCommentText(txt));
                    continue block5;
                }
                case PLAIN: {
                    if (txt.startsWith(PROPERTY_PREFIX) && txt.length() > 1) {
                        this.parseProperty(component, txt.substring(1), GraphParser.tokensToEOL(tokens));
                        allowCommands = false;
                        continue block5;
                    }
                    if (AT.equals(txt)) {
                        this.parseComponent(component, GraphParser.tokensToEOL(tokens));
                        allowCommands = false;
                        continue block5;
                    }
                    if (CONNECT.equals(txt)) {
                        this.parseConnection(component, GraphParser.tokensToEOL(tokens));
                        allowCommands = false;
                        continue block5;
                    }
                    if (allowCommands && component instanceof GraphBuilder.Root) {
                        GraphBuilder.Root root = (GraphBuilder.Root)component;
                        List<Token> toEOL = GraphParser.tokensToEOL(tokens);
                        root.command(GraphElement.command(body.substring(token.getStartIndex(), toEOL.isEmpty() ? token.getEndIndex() : toEOL.getLast().getEndIndex())));
                        continue block5;
                    }
                    throw new IllegalArgumentException("Unexpected PLAIN token : " + txt);
                }
                case EOL: {
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unexpected token of type : " + String.valueOf(token.getType()) + " , body : " + txt);
        }
    }

    private void parseProperty(GraphBuilder.Base<?> component, String property, List<Token> tokens) {
        if (tokens.size() != 1) {
            throw new IllegalArgumentException("Empty tokens passed to parseProperty ." + property);
        }
        Value value = this.context != null ? SyntaxUtils.valueFromToken(this.context, tokens.get(0)) : SyntaxUtils.valueFromToken(tokens.get(0));
        component.property(property, value);
    }

    private void parseConnection(GraphBuilder.Base<?> parent, List<Token> tokens) {
        if (tokens.size() != 2) {
            throw new IllegalArgumentException("Unexpected number of tokens in parseConnection");
        }
        Token source = tokens.get(0);
        Token target = tokens.get(1);
        String sourceComponent = null;
        String sourcePort = null;
        String targetComponent = null;
        String targetPort = null;
        try {
            PortAddress address;
            if (source.getType() == Token.Type.PLAIN && source.getText().startsWith(RELATIVE_ADDRESS_PREFIX)) {
                address = PortAddress.of((String)source.getText().substring(1));
                sourceComponent = address.component().componentID();
                sourcePort = address.portID();
            }
            if (target.getType() == Token.Type.PLAIN && target.getText().startsWith(RELATIVE_ADDRESS_PREFIX)) {
                address = PortAddress.of((String)target.getText().substring(1));
                targetComponent = address.component().componentID();
                targetPort = address.portID();
            }
            parent.connection(sourceComponent, sourcePort, targetComponent, targetPort);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid connection : " + String.valueOf(tokens), ex);
        }
    }

    static GraphElement.Root parse(String script) throws ParseException {
        return new GraphParser(Objects.requireNonNull(script), false, null).doParse();
    }

    static GraphElement.Root parseSubgraph(String script) throws ParseException {
        return new GraphParser(Objects.requireNonNull(script), true, null).doParse();
    }

    static GraphElement.Root parse(URI context, String script) throws ParseException {
        return new GraphParser(Objects.requireNonNull(script), false, Objects.requireNonNull(context)).doParse();
    }

    static GraphElement.Root parseSubgraph(URI context, String script) throws ParseException {
        return new GraphParser(Objects.requireNonNull(script), true, Objects.requireNonNull(context)).doParse();
    }
}

