/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.project;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.praxislive.core.Value;
import org.praxislive.project.GraphElement;
import org.praxislive.project.GraphModel;
import org.praxislive.project.SyntaxUtils;

class GraphWriter {
    private static final String INDENT = "  ";
    private static final String AT = "@";
    private static final String CONNECT = "~";
    private final GraphModel model;
    private final URI context;

    private GraphWriter(GraphModel model) {
        this.model = model;
        this.context = model.context().orElse(null);
    }

    private void doWrite(Appendable target) throws IOException {
        GraphElement.Root root = this.model.root();
        if (root.isSynthetic()) {
            this.writeCommands(target, root);
            this.writeChildren(target, root, 0);
            this.writeConnections(target, root, 0);
        } else {
            this.writeCommands(target, root);
            this.writeComponent(target, root.id(), root, 0);
        }
    }

    private void writeCommands(Appendable sb, GraphElement.Root root) throws IOException {
        for (GraphElement.Command cmd : root.commands()) {
            sb.append(cmd.command()).append('\n');
        }
    }

    private void writeComponent(Appendable sb, String id, GraphElement.Component cmp, int level) throws IOException {
        this.writeIndent(sb, level);
        sb.append(AT).append(' ');
        if (cmp instanceof GraphElement.Root) {
            sb.append('/').append(id);
        } else {
            sb.append("./").append(id);
        }
        sb.append(' ').append(cmp.type().toString()).append(" {\n");
        this.writeComments(sb, cmp, level + 1);
        this.writeProperties(sb, cmp, level + 1);
        this.writeChildren(sb, cmp, level + 1);
        this.writeConnections(sb, cmp, level + 1);
        this.writeIndent(sb, level);
        sb.append("}\n");
    }

    private void writeComments(Appendable sb, GraphElement.Component cmp, int level) throws IOException {
        for (GraphElement.Comment comment : cmp.comments()) {
            this.writeIndent(sb, level);
            sb.append("# ");
            sb.append(SyntaxUtils.escapeCommentText(comment.text()));
            sb.append('\n');
        }
    }

    private void writeProperties(Appendable sb, GraphElement.Component cmp, int level) throws IOException {
        for (Map.Entry entry : cmp.properties().entrySet()) {
            String id = (String)entry.getKey();
            Value value = ((GraphElement.Property)entry.getValue()).value();
            this.writeIndent(sb, level);
            sb.append('.').append(id).append(' ');
            if (this.context != null) {
                SyntaxUtils.writeValue(this.context, value, sb);
            } else {
                SyntaxUtils.writeValue(value, sb);
            }
            sb.append('\n');
        }
    }

    private void writeChildren(Appendable sb, GraphElement.Component cmp, int level) throws IOException {
        for (Map.Entry entry : cmp.children().entrySet()) {
            String id = (String)entry.getKey();
            GraphElement.Component child = (GraphElement.Component)entry.getValue();
            this.writeComponent(sb, id, child, level);
        }
    }

    private void writeConnections(Appendable sb, GraphElement.Component cmp, int level) throws IOException {
        for (GraphElement.Connection c : cmp.connections()) {
            this.writeIndent(sb, level);
            sb.append(CONNECT).append(' ');
            sb.append("./").append(c.sourceComponent()).append('!').append(c.sourcePort()).append(' ');
            sb.append("./").append(c.targetComponent()).append('!').append(c.targetPort()).append('\n');
        }
    }

    private void writeIndent(Appendable sb, int level) throws IOException {
        for (int i = 0; i < level; ++i) {
            sb.append(INDENT);
        }
    }

    static void write(GraphModel model, Appendable target) throws IOException {
        GraphWriter writer = new GraphWriter(model);
        writer.doWrite(target);
    }
}

