/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.project;

import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.praxislive.core.syntax.Token;
import org.praxislive.core.syntax.Tokenizer;

public abstract sealed class ProjectElement {
    public static File file(URI file) {
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException("File URI must be absolute");
        }
        return new File(file);
    }

    public static File file(Path file) {
        return ProjectElement.file(file.toUri());
    }

    public static Line line(String script) {
        Iterator itr = new Tokenizer((CharSequence)script).iterator();
        ArrayList<Token> tokens = new ArrayList<Token>();
        while (itr.hasNext()) {
            Token token = (Token)itr.next();
            if (tokens.isEmpty() && token.getType() != Token.Type.PLAIN) {
                throw new IllegalArgumentException("First token of a command must be plain");
            }
            if (token.getType() == Token.Type.COMMENT) {
                throw new IllegalArgumentException("Invalid command - contains a comment");
            }
            if (token.getType() == Token.Type.EOL) break;
            tokens.add(token);
        }
        if (itr.hasNext()) {
            throw new IllegalArgumentException("Invalid command - tokens found after EOL");
        }
        return new Line(script, List.copyOf(tokens));
    }

    public static final class File
    extends ProjectElement {
        private final URI file;

        private File(URI file) {
            this.file = file;
        }

        public URI file() {
            return this.file;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (obj == this) return true;
            if (!(obj instanceof File)) return false;
            File other = (File)obj;
            if (!Objects.equals(this.file, other.file)) return false;
            return true;
        }

        public int hashCode() {
            return this.file.hashCode();
        }

        public String toString() {
            return "ProjectElement.File{uri=" + String.valueOf(this.file) + "}";
        }
    }

    public static final class Line
    extends ProjectElement {
        private final String script;
        private final List<Token> tokens;

        private Line(String script, List<Token> tokens) {
            this.script = script;
            this.tokens = tokens;
        }

        public String line() {
            return this.script;
        }

        public List<Token> tokens() {
            return this.tokens;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (obj == this) return true;
            if (!(obj instanceof Line)) return false;
            Line other = (Line)obj;
            if (!Objects.equals(this.script, other.script)) return false;
            return true;
        }

        public int hashCode() {
            return this.script.hashCode();
        }

        public String toString() {
            return "ProjectElement.Line{script=" + this.script + "}";
        }
    }
}

