/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.project;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.praxislive.project.ModelUtils;
import org.praxislive.project.ParseException;
import org.praxislive.project.ProjectElement;
import org.praxislive.project.ProjectParser;
import org.praxislive.project.ProjectWriter;

public final class ProjectModel {
    static final String INCLUDE_CMD = "include";
    static final String BUILD_LEVEL_SWITCH = "<<<BUILD>>>";
    static final String RUN_LEVEL_SWITCH = "<<<RUN>>>";
    private final List<ProjectElement> setupElements;
    private final List<ProjectElement> buildElements;
    private final List<ProjectElement> runElements;
    private final URI context;

    private ProjectModel(List<ProjectElement> setupElements, List<ProjectElement> buildElements, List<ProjectElement> runElements, URI context) {
        this.setupElements = List.copyOf(setupElements);
        this.buildElements = List.copyOf(buildElements);
        this.runElements = List.copyOf(runElements);
        this.context = context;
    }

    public List<ProjectElement> setupElements() {
        return this.setupElements;
    }

    public List<ProjectElement> buildElements() {
        return this.buildElements;
    }

    public List<ProjectElement> runElements() {
        return this.runElements;
    }

    public Optional<URI> context() {
        return Optional.ofNullable(this.context);
    }

    public ProjectModel withContext(URI context) {
        return new ProjectModel(this.setupElements, this.buildElements, this.runElements, ModelUtils.validateContext(context));
    }

    public void write(Appendable target) throws IOException {
        ProjectWriter.write(this, target);
    }

    public String writeToString() {
        StringBuilder sb = new StringBuilder();
        try {
            this.write(sb);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof ProjectModel)) return false;
        ProjectModel other = (ProjectModel)obj;
        if (!Objects.equals(this.setupElements, other.setupElements)) return false;
        if (!Objects.equals(this.buildElements, other.buildElements)) return false;
        if (!Objects.equals(this.runElements, other.runElements)) return false;
        if (!Objects.equals(this.context, other.context)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.setupElements, this.buildElements, this.runElements, this.context);
    }

    public String toString() {
        return "ProjectModel {\n  Context : " + String.valueOf(this.context) + "\n  Project :\n" + this.writeToString().indent(4) + "\n}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ProjectModel parse(String script) throws ParseException {
        return ProjectParser.parse(script);
    }

    public static ProjectModel parse(URI context, String script) throws ParseException {
        return ProjectParser.parse(ModelUtils.validateContext(context), script);
    }

    public static final class Builder {
        private final List<ProjectElement> setupElements = new ArrayList<ProjectElement>();
        private final List<ProjectElement> buildElements = new ArrayList<ProjectElement>();
        private final List<ProjectElement> runElements = new ArrayList<ProjectElement>();
        private URI context;

        private Builder() {
        }

        public Builder setupElement(ProjectElement element) {
            this.setupElements.add(Objects.requireNonNull(element));
            return this;
        }

        public Builder buildElement(ProjectElement element) {
            this.buildElements.add(Objects.requireNonNull(element));
            return this;
        }

        public Builder runElement(ProjectElement element) {
            this.runElements.add(Objects.requireNonNull(element));
            return this;
        }

        public Builder context(URI context) {
            this.context = ModelUtils.validateContext(context);
            return this;
        }

        public ProjectModel build() {
            return new ProjectModel(this.setupElements, this.buildElements, this.runElements, this.context);
        }
    }
}

