/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.project;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.praxislive.core.Value;
import org.praxislive.core.syntax.Token;
import org.praxislive.core.syntax.Tokenizer;
import org.praxislive.core.types.PResource;
import org.praxislive.project.ParseException;
import org.praxislive.project.ProjectElement;
import org.praxislive.project.ProjectModel;
import org.praxislive.project.SyntaxUtils;

class ProjectParser {
    private final String script;
    private final URI context;
    private ExecutionLevel level;

    private ProjectParser(String script, URI context) {
        this.script = script;
        this.context = context;
    }

    private ProjectModel doParse() throws ParseException {
        try {
            this.level = ExecutionLevel.SETUP;
            Iterator tokens = new Tokenizer((CharSequence)this.script).iterator();
            ArrayList<Token> line = new ArrayList<Token>();
            ProjectModel.Builder builder = ProjectModel.builder();
            if (this.context != null) {
                builder.context(this.context);
            }
            block7: while (tokens.hasNext()) {
                line.clear();
                ProjectParser.tokensToEOL(tokens, line);
                if (line.isEmpty()) continue;
                Token first = (Token)line.getFirst();
                switch (first.getType()) {
                    case PLAIN: {
                        this.parseCommand(builder, line);
                        continue block7;
                    }
                    case COMMENT: {
                        this.parseComment(line);
                        continue block7;
                    }
                }
                throw new ParseException("Unexpected token type");
            }
            return builder.build();
        }
        catch (ParseException pex) {
            throw pex;
        }
        catch (Exception ex) {
            throw new ParseException(ex);
        }
    }

    private void addElement(ProjectModel.Builder builder, ProjectElement element) {
        switch (this.level.ordinal()) {
            case 0: {
                builder.setupElement(element);
                break;
            }
            case 1: {
                builder.buildElement(element);
                break;
            }
            case 2: {
                builder.runElement(element);
            }
        }
    }

    private void parseCommand(ProjectModel.Builder builder, List<Token> tokens) throws ParseException {
        String command = tokens.get(0).getText();
        if ("include".equals(command)) {
            this.parseInclude(builder, tokens);
        } else {
            String line = this.script.substring(tokens.get(0).getStartIndex(), tokens.get(tokens.size() - 1).getEndIndex());
            this.addElement(builder, ProjectElement.line(line));
        }
    }

    private void parseInclude(ProjectModel.Builder builder, List<Token> tokens) throws ParseException {
        if (tokens.size() != 2) {
            throw new ParseException("Unexpected number of arguments in include command");
        }
        Value resource = this.context != null ? SyntaxUtils.valueFromToken(this.context, tokens.get(1)) : SyntaxUtils.valueFromToken(tokens.get(1));
        this.addElement(builder, ProjectElement.file(PResource.from((Value)resource).map(PResource::value).orElseThrow(() -> new ParseException("Include is not a valid resource"))));
    }

    private void parseComment(List<Token> tokens) throws ParseException {
        String text = tokens.get(0).getText();
        if (text.contains("<<<BUILD>>>")) {
            this.switchLevel(ExecutionLevel.BUILD);
        } else if (text.contains("<<<RUN>>>")) {
            this.switchLevel(ExecutionLevel.RUN);
        }
    }

    private void switchLevel(ExecutionLevel level) throws ParseException {
        if (level.compareTo(this.level) < 0) {
            throw new ParseException("Can't move level down");
        }
        this.level = level;
    }

    private static void tokensToEOL(Iterator<Token> tokens, List<Token> line) {
        Token t;
        while (tokens.hasNext() && (t = tokens.next()).getType() != Token.Type.EOL) {
            line.add(t);
        }
    }

    static ProjectModel parse(String script) throws ParseException {
        return new ProjectParser(Objects.requireNonNull(script), null).doParse();
    }

    static ProjectModel parse(URI context, String script) throws ParseException {
        return new ProjectParser(Objects.requireNonNull(script), Objects.requireNonNull(context)).doParse();
    }

    private static enum ExecutionLevel {
        SETUP,
        BUILD,
        RUN;

    }
}

