/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.project;

import java.io.IOException;
import java.net.URI;
import org.praxislive.core.Value;
import org.praxislive.core.types.PResource;
import org.praxislive.project.ProjectElement;
import org.praxislive.project.ProjectModel;
import org.praxislive.project.SyntaxUtils;

class ProjectWriter {
    private final ProjectModel model;
    private final URI context;

    private ProjectWriter(ProjectModel model) {
        this.model = model;
        this.context = model.context().orElse(null);
    }

    private void doWrite(Appendable target) throws IOException {
        for (ProjectElement e : this.model.setupElements()) {
            this.writeElement(target, e);
        }
        target.append("\n# ").append("<<<BUILD>>>").append('\n');
        for (ProjectElement e : this.model.buildElements()) {
            this.writeElement(target, e);
        }
        target.append("\n# ").append("<<<RUN>>>").append('\n');
        for (ProjectElement e : this.model.runElements()) {
            this.writeElement(target, e);
        }
    }

    private void writeElement(Appendable target, ProjectElement element) throws IOException {
        if (element instanceof ProjectElement.File) {
            ProjectElement.File fileElement = (ProjectElement.File)element;
            this.writeFileElement(target, fileElement);
        } else if (element instanceof ProjectElement.Line) {
            ProjectElement.Line lineElement = (ProjectElement.Line)element;
            this.writeLineElement(target, lineElement);
        }
    }

    private void writeFileElement(Appendable target, ProjectElement.File fileElement) throws IOException {
        target.append("include").append(' ');
        PResource resource = PResource.of((URI)fileElement.file());
        if (this.context != null) {
            target.append(SyntaxUtils.valueToToken(this.context, (Value)resource));
        } else {
            target.append(SyntaxUtils.valueToToken((Value)resource));
        }
        target.append('\n');
    }

    private void writeLineElement(Appendable target, ProjectElement.Line lineElement) throws IOException {
        target.append(lineElement.line()).append('\n');
    }

    static void write(ProjectModel model, Appendable target) throws IOException {
        ProjectWriter writer = new ProjectWriter(model);
        writer.doWrite(target);
    }
}

