/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.project;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.PortAddress;
import org.praxislive.core.Value;
import org.praxislive.core.ValueFormatException;
import org.praxislive.core.syntax.Token;
import org.praxislive.core.syntax.Tokenizer;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PBoolean;
import org.praxislive.core.types.PMap;
import org.praxislive.core.types.PNumber;
import org.praxislive.core.types.PResource;
import org.praxislive.core.types.PString;

public class SyntaxUtils {
    private static final String DIGITS = "0123456789";
    private static final String REQUIRE_QUOTING = "{}[];'\"\\";
    private static final String REQUIRE_QUOTING_START = ".#${}[];'\"\\";
    private static final int MAX_LENGTH_PLAIN = 128;

    private SyntaxUtils() {
    }

    public static String escape(String input) {
        String res = SyntaxUtils.doPlain(input);
        if (res == null) {
            res = SyntaxUtils.doQuoted(input);
        }
        return res;
    }

    public static String escapeQuoted(String input) {
        return SyntaxUtils.doQuoted(input);
    }

    public static boolean isSafeBraced(String input) {
        int idx;
        int len = input.length();
        if (len == 0) {
            return true;
        }
        int level = 0;
        block4: for (idx = 0; idx < len && level > -1; ++idx) {
            char ch = input.charAt(idx);
            switch (ch) {
                case '}': {
                    if (idx > 0 && input.charAt(idx - 1) == '\\') continue block4;
                    --level;
                    continue block4;
                }
                case '{': {
                    if (idx > 0 && input.charAt(idx - 1) == '\\') continue block4;
                    ++level;
                }
            }
        }
        return idx == len && level == 0;
    }

    public static Value valueFromToken(Token token) {
        return SyntaxUtils.valueFromTokenImpl(null, token);
    }

    public static Value valueFromToken(URI context, Token token) {
        return SyntaxUtils.valueFromTokenImpl(Objects.requireNonNull(context), token);
    }

    public static String valueToToken(Value value) {
        StringBuilder sb = new StringBuilder();
        try {
            SyntaxUtils.writeValue(value, sb);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return sb.toString();
    }

    public static String valueToToken(URI context, Value value) {
        StringBuilder sb = new StringBuilder();
        try {
            SyntaxUtils.writeValue(context, value, sb);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return sb.toString();
    }

    public static void writeValue(Value value, Appendable out) throws IOException {
        SyntaxUtils.writeValueImpl(null, Objects.requireNonNull(value), Objects.requireNonNull(out));
    }

    public static void writeValue(URI context, Value value, Appendable out) throws IOException {
        SyntaxUtils.writeValueImpl(Objects.requireNonNull(context), Objects.requireNonNull(value), Objects.requireNonNull(out));
    }

    /*
     * Unable to fully structure code
     */
    static String unescapeCommentText(String text) {
        if (!text.contains("\\")) {
            return text;
        }
        len = text.length();
        sb = new StringBuilder(len);
        block5: for (i = 0; i < len; ++i) {
            c = text.charAt(i);
            if (c != '\\') ** GOTO lbl-1000
            c = text.charAt(++i);
            switch (c) {
                case 'n': {
                    sb.append('\n');
                    continue block5;
                }
                case 't': {
                    sb.append('\t');
                    continue block5;
                }
                case 'r': {
                    continue block5;
                }
                default: lbl-1000:
                // 2 sources

                {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    static String escapeCommentText(String text) {
        int len = text.length();
        StringBuilder sb = new StringBuilder(len * 2);
        block6: for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\"': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '}': {
                    sb.append('\\').append(c);
                    continue block6;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block6;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block6;
                }
                case '\r': {
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '\\') {
            sb.append(' ');
        }
        return sb.toString();
    }

    private static String doPlain(String input) {
        int len = input.length();
        if (len == 0 || len > 128) {
            return null;
        }
        char c = input.charAt(0);
        if (Character.isWhitespace(c) || REQUIRE_QUOTING_START.indexOf(c) > -1) {
            return null;
        }
        for (int i = 1; i < len; ++i) {
            c = input.charAt(i);
            if (!Character.isWhitespace(c) && REQUIRE_QUOTING.indexOf(c) <= -1) continue;
            return null;
        }
        return input;
    }

    private static String doQuoted(String input) {
        int len = input.length();
        if (len == 0) {
            return "\"\"";
        }
        StringBuilder sb = new StringBuilder(len * 2);
        sb.append("\"");
        block5: for (int i = 0; i < len; ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    sb.append('\\').append(c);
                    continue block5;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block5;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append("\"");
        return sb.toString();
    }

    private static Value valueFromTokenImpl(URI context, Token token) {
        Objects.requireNonNull(token);
        return switch (token.getType()) {
            case Token.Type.PLAIN -> SyntaxUtils.valueFromPlainToken(token.getText());
            case Token.Type.QUOTED, Token.Type.BRACED -> PString.of((String)token.getText());
            case Token.Type.SUBCOMMAND -> SyntaxUtils.valueFromSubcommand(context, token.getText());
            default -> throw new IllegalArgumentException("Invalid token type : " + String.valueOf(token));
        };
    }

    private static Value valueFromPlainToken(String text) {
        if (!SyntaxUtils.isSafePlainToken(text)) {
            throw new IllegalArgumentException("Unsupported plain token");
        }
        if ("true".equals(text)) {
            return PBoolean.TRUE;
        }
        if ("false".equals(text)) {
            return PBoolean.FALSE;
        }
        int length = text.length();
        if (length > 0) {
            char c = text.charAt(0);
            if (DIGITS.indexOf(c) > -1 || c == '-' && length > 1 && DIGITS.indexOf(text.charAt(1)) > -1) {
                return SyntaxUtils.numberOrString(text);
            }
            if (c == '/' && length > 1) {
                return SyntaxUtils.addressOrString(text);
            }
        }
        return PString.of((String)text);
    }

    private static Value numberOrString(String text) {
        try {
            return PNumber.parse((String)text);
        }
        catch (Exception ex) {
            return PString.of((String)text);
        }
    }

    private static Value addressOrString(String text) {
        try {
            if (text.lastIndexOf(46) > -1) {
                return ControlAddress.parse((String)text);
            }
            if (text.lastIndexOf(33) > -1) {
                return PortAddress.parse((String)text);
            }
            return ComponentAddress.parse((String)text);
        }
        catch (Exception ex) {
            return PString.of((String)text);
        }
    }

    private static Value valueFromSubcommand(URI context, String command) {
        List<Token> tokens = SyntaxUtils.subcommandTokens(command);
        Token token = tokens.get(0);
        if (tokens.get(0).getType() != Token.Type.PLAIN) {
            throw new IllegalArgumentException("First token is not a plain command : " + command);
        }
        return switch (token.getText()) {
            case "array" -> SyntaxUtils.arrayFromCommand(context, tokens);
            case "map" -> SyntaxUtils.mapFromCommand(context, tokens);
            case "file" -> SyntaxUtils.fileFromCommand(context, tokens);
            case "file-list" -> PArray.EMPTY;
            default -> throw new IllegalArgumentException("Unsupported subcommand : " + token.getText());
        };
    }

    private static List<Token> subcommandTokens(String command) {
        Iterator tokens = new Tokenizer((CharSequence)command).iterator();
        ArrayList<Token> result = new ArrayList<Token>();
        while (tokens.hasNext()) {
            Token t = (Token)tokens.next();
            if (t.getType() == Token.Type.COMMENT) continue;
            if (t.getType() == Token.Type.EOL) break;
            result.add(t);
        }
        if (tokens.hasNext()) {
            throw new IllegalArgumentException("More than one command found in subcommand token : " + command);
        }
        if (result.isEmpty()) {
            throw new IllegalArgumentException("Empty subcommand");
        }
        return result;
    }

    private static PArray arrayFromCommand(URI context, List<Token> tokens) {
        if (tokens.size() == 1) {
            return PArray.EMPTY;
        }
        List<Value> values = tokens.stream().skip(1L).map(t -> SyntaxUtils.valueFromTokenImpl(context, t)).toList();
        return PArray.of(values);
    }

    private static PMap mapFromCommand(URI context, List<Token> tokens) {
        if (tokens.size() == 1) {
            return PMap.EMPTY;
        }
        int size = tokens.size();
        if (size % 2 != 1) {
            throw new IllegalArgumentException("Map requires an even number of arguments");
        }
        PMap.Builder builder = PMap.builder();
        for (int i = 1; i < size; i += 2) {
            Token keyToken = tokens.get(i);
            if (keyToken.getType() == Token.Type.SUBCOMMAND || keyToken.getType() == Token.Type.EOL || keyToken.getType() == Token.Type.COMMENT) {
                throw new IllegalArgumentException("Invalid key token type : " + String.valueOf(keyToken));
            }
            String key = keyToken.getText();
            if (keyToken.getType() == Token.Type.PLAIN && !SyntaxUtils.isSafePlainToken(key)) {
                throw new IllegalArgumentException("Invalid plain key : " + key);
            }
            builder.put(key, SyntaxUtils.valueFromTokenImpl(context, tokens.get(i + 1)));
        }
        return builder.build();
    }

    private static PResource fileFromCommand(URI context, List<Token> tokens) {
        if (context == null) {
            throw new IllegalArgumentException("Relative files cannot be parsed without working directory");
        }
        if (tokens.size() != 2) {
            throw new IllegalArgumentException("Invalid number of arguments for file subcommand");
        }
        Token pathToken = tokens.get(1);
        if (pathToken.getType() == Token.Type.SUBCOMMAND || pathToken.getType() == Token.Type.EOL || pathToken.getType() == Token.Type.COMMENT) {
            throw new IllegalArgumentException("Invalid path token type : " + String.valueOf(pathToken));
        }
        String path = pathToken.getText();
        if (pathToken.getType() == Token.Type.PLAIN && !SyntaxUtils.isSafePlainToken(path)) {
            throw new IllegalArgumentException("Invalid plain path : " + path);
        }
        try {
            URI uri2;
            if (path.contains(":")) {
                try {
                    uri2 = new URI(path);
                    if (uri2.isAbsolute()) {
                        return PResource.of((URI)uri2);
                    }
                }
                catch (URISyntaxException uri2) {
                    // empty catch block
                }
            }
            uri2 = context.resolve(new URI(null, null, path, null));
            return PResource.of((URI)uri2);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static boolean isSafePlainToken(String text) {
        return !text.startsWith("$") && !text.startsWith(".");
    }

    private static void writeValueImpl(URI context, Value value, Appendable out) throws IOException {
        Value value2 = value;
        Objects.requireNonNull(value2);
        Value value3 = value2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PMap.class, PArray.class, PResource.class, PString.class}, (Object)value3, n)) {
            case 0: {
                PMap map = (PMap)value3;
                SyntaxUtils.writePMap(context, map, out);
                break;
            }
            case 1: {
                PArray array = (PArray)value3;
                SyntaxUtils.writePArray(context, array, out);
                break;
            }
            case 2: {
                PResource resource = (PResource)value3;
                SyntaxUtils.writePResource(context, resource, out);
                break;
            }
            case 3: {
                PString string = (PString)value3;
                SyntaxUtils.writePString(context, string, out);
                break;
            }
            default: {
                out.append(SyntaxUtils.escape(value.toString()));
            }
        }
    }

    private static void writePMap(URI context, PMap map, Appendable out) throws IOException {
        if (map.isEmpty()) {
            out.append("[map]");
            return;
        }
        out.append("[map");
        for (Map.Entry entry : map.asMap().entrySet()) {
            out.append(" ").append(SyntaxUtils.escape((String)entry.getKey())).append(" ");
            SyntaxUtils.writeValueImpl(context, (Value)entry.getValue(), out);
        }
        out.append("]");
    }

    private static void writePArray(URI context, PArray array, Appendable out) throws IOException {
        if (array.isEmpty()) {
            out.append("[array]");
            return;
        }
        out.append("[array");
        for (Value value : array) {
            out.append(" ");
            SyntaxUtils.writeValueImpl(context, value, out);
        }
        out.append("]");
    }

    private static void writePResource(URI context, PResource resource, Appendable out) throws IOException {
        URI res;
        if (context != null && !(res = context.relativize(resource.value())).isAbsolute()) {
            out.append("[file ").append(SyntaxUtils.escapeQuoted(res.getPath())).append("]");
            return;
        }
        out.append(SyntaxUtils.escape(resource.toString()));
    }

    private static void writePString(URI context, PString string, Appendable out) throws IOException {
        String text = string.toString();
        int lines = (int)text.lines().limit(3L).count();
        if (lines > 2 && SyntaxUtils.isSafeBraced(text)) {
            out.append("{").append(text).append("}");
            return;
        }
        if (lines == 1 && text.contains(":/")) {
            try {
                PResource res = PResource.parse((String)text);
                SyntaxUtils.writePResource(context, res, out);
                return;
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
        }
        out.append(SyntaxUtils.escape(text));
    }
}

