/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.gstreamer.configuration;

import com.sun.jna.Platform;
import org.praxislive.core.Settings;

public class GStreamerSettings {
    private static final String KEY_CAPTURE_PREFIX = "video.gstreamer.capture";
    private static final String KEY_LIBRARY_PATH = "video.gstreamer.path";
    private static final String DEFAULT_CAPTURE_PREFIX;
    private static final String DEFAULT_LIBRARY_PATH;

    public static String getDefaultCaptureDevice(int idx) {
        if (idx < 1) {
            throw new IllegalArgumentException();
        }
        return DEFAULT_CAPTURE_PREFIX + (idx - 1);
    }

    public static void resetCaptureDevice(int idx) {
        GStreamerSettings.setCaptureDevice(idx, null);
    }

    public static String getCaptureDevice(int idx) {
        if (idx < 1) {
            throw new IllegalArgumentException();
        }
        return Settings.get((String)(KEY_CAPTURE_PREFIX + idx), (String)GStreamerSettings.getDefaultCaptureDevice(idx));
    }

    public static void setCaptureDevice(int idx, String device) {
        if (idx < 1) {
            throw new IllegalArgumentException();
        }
        Settings.put((String)(KEY_CAPTURE_PREFIX + idx), (String)device);
    }

    public static String getDefaultLibraryPath() {
        return DEFAULT_LIBRARY_PATH;
    }

    public static void resetLibraryPath() {
        GStreamerSettings.setLibraryPath(null);
    }

    public static String getLibraryPath() {
        return Settings.get((String)KEY_LIBRARY_PATH, (String)GStreamerSettings.getDefaultLibraryPath());
    }

    public static void setLibraryPath(String libPath) {
        Settings.put((String)KEY_LIBRARY_PATH, (String)libPath);
    }

    static {
        if (Platform.isWindows()) {
            DEFAULT_CAPTURE_PREFIX = "ksvideosrc device-index=";
            DEFAULT_LIBRARY_PATH = Platform.is64Bit() ? "C:\\gstreamer\\1.0\\x86_64\\bin\\" : "C:\\gstreamer\\1.0\\x86\\bin\\";
        } else if (Platform.isMac()) {
            DEFAULT_CAPTURE_PREFIX = "avfvideosrc device-index=";
            DEFAULT_LIBRARY_PATH = "/Library/Frameworks/GStreamer.framework/Libraries/";
        } else {
            DEFAULT_CAPTURE_PREFIX = "v4l2src device=/dev/video";
            DEFAULT_LIBRARY_PATH = "";
        }
    }
}

