/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.gstreamer.components;

import java.lang.reflect.Field;
import org.praxislive.code.CodeConnector;
import org.praxislive.code.ReferenceDescriptor;
import org.praxislive.code.userapi.Inject;
import org.praxislive.core.services.LogLevel;
import org.praxislive.video.code.VideoCodeConnector;
import org.praxislive.video.gstreamer.VideoCapture;
import org.praxislive.video.gstreamer.VideoPlayer;
import org.praxislive.video.gstreamer.components.GStreamerLibrary;
import org.praxislive.video.gstreamer.components.GStreamerVideoCapture;
import org.praxislive.video.gstreamer.components.GStreamerVideoPlayer;

public class GStreamerCodePlugin
implements CodeConnector.Plugin {
    public boolean isSupportedConnector(CodeConnector<?> connector) {
        return connector instanceof VideoCodeConnector;
    }

    public boolean analyseField(CodeConnector<?> connector, Field field) {
        Class<?> fieldType = field.getType();
        if ((fieldType == VideoCapture.class || fieldType == VideoPlayer.class) && field.isAnnotationPresent(Inject.class) && this.initGStreamer(connector)) {
            ReferenceDescriptor dsc;
            ReferenceDescriptor referenceDescriptor = dsc = fieldType == VideoCapture.class ? GStreamerVideoCapture.Descriptor.create(connector, field) : GStreamerVideoPlayer.Descriptor.create(connector, field);
            if (dsc != null) {
                connector.addReference(dsc);
                return true;
            }
        }
        return false;
    }

    private boolean initGStreamer(CodeConnector<?> connector) {
        try {
            GStreamerLibrary.getInstance().init();
            return true;
        }
        catch (Throwable th) {
            Exception ex = th instanceof Exception ? (Exception)th : new IllegalStateException(th);
            connector.getLog().log(LogLevel.ERROR, ex, "Unable to initialize GStreamer library");
            return false;
        }
    }
}

