/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.gstreamer.components;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.freedesktop.gstreamer.Buffer;
import org.freedesktop.gstreamer.Caps;
import org.freedesktop.gstreamer.FlowReturn;
import org.freedesktop.gstreamer.Sample;
import org.freedesktop.gstreamer.Structure;
import org.freedesktop.gstreamer.elements.AppSink;
import org.praxislive.video.code.userapi.PImage;
import org.praxislive.video.render.NativePixelData;
import org.praxislive.video.render.PixelData;
import org.praxislive.video.render.Surface;
import org.praxislive.video.render.SurfaceOp;

class PImageSink {
    private static final String DEFAULT_CAPS = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "video/x-raw, format=BGRx, pixel-aspect-ratio=1/1" : "video/x-raw, format=xRGB, pixel-aspect-ratio=1/1";
    private final AppSink sink;
    private final Lock imageLock;
    private final NewSampleListener newSampleListener;
    private final NewPrerollListener newPrerollListener;
    private GStreamerSurface surface;
    private int requestWidth;
    private int requestHeight;
    private int requestRate;

    PImageSink() {
        this(new AppSink("PImageSink"));
    }

    PImageSink(AppSink sink) {
        this.sink = sink;
        sink.set("emit-signals", (Object)true);
        this.newSampleListener = new NewSampleListener();
        this.newPrerollListener = new NewPrerollListener();
        sink.connect((AppSink.NEW_SAMPLE)this.newSampleListener);
        sink.connect((AppSink.NEW_PREROLL)this.newPrerollListener);
        sink.setCaps(Caps.fromString((String)DEFAULT_CAPS));
        this.imageLock = new ReentrantLock();
    }

    private String buildCapsString() {
        if (this.requestWidth < 1 && this.requestHeight < 1 && this.requestRate < 1) {
            return DEFAULT_CAPS;
        }
        StringBuilder sb = new StringBuilder(DEFAULT_CAPS);
        if (this.requestWidth > 0) {
            sb.append(",width=");
            sb.append(this.requestWidth);
        }
        if (this.requestHeight > 0) {
            sb.append(",height=");
            sb.append(this.requestHeight);
        }
        if (this.requestRate > 0) {
            sb.append(",framerate=");
            sb.append(this.requestRate);
            sb.append("/1");
        }
        return sb.toString();
    }

    AppSink getElement() {
        return this.sink;
    }

    void requestFrameSize(int width, int height) {
        this.requestWidth = width;
        this.requestHeight = height;
        this.sink.setCaps(Caps.fromString((String)this.buildCapsString()));
    }

    void requestFrameRate(double rate) {
        this.requestRate = (int)Math.round(rate);
        this.sink.setCaps(Caps.fromString((String)this.buildCapsString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean render(Consumer<PImage> renderer) {
        this.imageLock.lock();
        try {
            if (this.surface != null && this.surface.sample != null) {
                Buffer b = this.surface.sample.getBuffer();
                this.surface.nativeData = b.map(false);
                try {
                    renderer.accept(this.surface.image);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.surface.nativeData = null;
                b.unmap();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.imageLock.unlock();
        }
    }

    void dispose() {
        this.imageLock.lock();
        try {
            if (this.surface != null && this.surface.sample != null) {
                this.surface.sample.dispose();
            }
            this.surface = null;
        }
        finally {
            this.imageLock.unlock();
        }
    }

    private static class GStreamerSurface
    extends Surface
    implements NativePixelData {
        private static PixelData[] EMPTY = new PixelData[0];
        private final PImage image;
        private Sample sample;
        private ByteBuffer nativeData;
        private int[] data;
        private int modCount;

        private GStreamerSurface(int width, int height) {
            super(width, height, false);
            this.image = new PImage(width, height){

                protected Surface getSurface() {
                    return this;
                }
            };
        }

        public int getModCount() {
            return this.modCount;
        }

        public void process(SurfaceOp op, Surface ... inputs) {
            if (inputs.length > 0) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
            ++this.modCount;
            op.process((PixelData)this, EMPTY);
        }

        public void clear() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isClear() {
            return false;
        }

        public void release() {
        }

        public void copy(Surface source) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean checkCompatible(Surface surface, boolean checkDimensions, boolean checkAlpha) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Surface createSurface(int width, int height, boolean alpha) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int[] getData() {
            if (this.data == null) {
                this.data = new int[this.width * this.height];
            }
            IntBuffer ib = this.getNativeData().asIntBuffer();
            ib.get(this.data);
            return this.data;
        }

        public int getOffset() {
            return 0;
        }

        public int getScanline() {
            return this.width;
        }

        public ByteBuffer getNativeData() {
            return this.nativeData;
        }

        public NativePixelData.Format getFormat() {
            return NativePixelData.Format.INT_RGB;
        }
    }

    private class NewPrerollListener
    implements AppSink.NEW_PREROLL {
        private NewPrerollListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FlowReturn newPreroll(AppSink sink) {
            PImageSink.this.imageLock.lock();
            try {
                Sample sample = sink.pullPreroll();
                Structure capsStruct = sample.getCaps().getStructure(0);
                int width = capsStruct.getInteger("width");
                int height = capsStruct.getInteger("height");
                if (PImageSink.this.surface == null || PImageSink.this.surface.getWidth() != width || PImageSink.this.surface.getHeight() != height) {
                    if (PImageSink.this.surface != null && PImageSink.this.surface.sample != null) {
                        PImageSink.this.surface.sample.dispose();
                    }
                    PImageSink.this.surface = new GStreamerSurface(width, height);
                } else if (PImageSink.this.surface.sample != null) {
                    PImageSink.this.surface.sample.dispose();
                }
                PImageSink.this.surface.sample = sample;
                ++PImageSink.this.surface.modCount;
            }
            finally {
                PImageSink.this.imageLock.unlock();
            }
            return FlowReturn.OK;
        }
    }

    private class NewSampleListener
    implements AppSink.NEW_SAMPLE {
        private NewSampleListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FlowReturn newSample(AppSink sink) {
            PImageSink.this.imageLock.lock();
            try {
                Sample sample = sink.pullSample();
                Structure capsStruct = sample.getCaps().getStructure(0);
                int width = capsStruct.getInteger("width");
                int height = capsStruct.getInteger("height");
                if (PImageSink.this.surface == null || PImageSink.this.surface.getWidth() != width || PImageSink.this.surface.getHeight() != height) {
                    if (PImageSink.this.surface != null && PImageSink.this.surface.sample != null) {
                        PImageSink.this.surface.sample.dispose();
                    }
                    PImageSink.this.surface = new GStreamerSurface(width, height);
                } else if (PImageSink.this.surface.sample != null) {
                    PImageSink.this.surface.sample.dispose();
                }
                PImageSink.this.surface.sample = sample;
                ++PImageSink.this.surface.modCount;
            }
            finally {
                PImageSink.this.imageLock.unlock();
            }
            return FlowReturn.OK;
        }
    }
}

