/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.gstreamer.components;

import org.praxislive.code.userapi.AuxOut;
import org.praxislive.code.userapi.Config;
import org.praxislive.code.userapi.Constants;
import org.praxislive.code.userapi.Inject;
import org.praxislive.code.userapi.OnChange;
import org.praxislive.code.userapi.Output;
import org.praxislive.code.userapi.P;
import org.praxislive.code.userapi.Property;
import org.praxislive.code.userapi.ReadOnly;
import org.praxislive.code.userapi.T;
import org.praxislive.code.userapi.Trigger;
import org.praxislive.code.userapi.Type;
import org.praxislive.core.Value;
import org.praxislive.core.types.PBoolean;
import org.praxislive.core.types.PResource;
import org.praxislive.video.code.VideoCodeDelegate;
import org.praxislive.video.code.userapi.PImage;
import org.praxislive.video.gstreamer.VideoPlayer;

public class VideoPlayerComponent
extends VideoCodeDelegate {
    static final String TEMPLATE_PATH = "resources/video_player.pxj";
    @T(value=1)
    Trigger play;
    @T(value=2)
    Trigger pause;
    @T(value=3)
    Trigger stop;
    @P(value=1)
    @Type(value=PResource.class, properties={"allow-empty", "true"})
    Property video;
    @P(value=2)
    @OnChange(value="seek")
    @Type.Number(min=0.0, max=1.0)
    double position;
    @P(value=3)
    @Type.Number(def=1.0)
    Property rate;
    @P(value=4)
    @Type.Boolean(def=true)
    Property loop;
    @P(value=5)
    ResizeMode resizeMode;
    @P(value=6)
    @Type.Number(min=0.0, max=1.0, def=0.5)
    double alignX;
    @P(value=7)
    @Type.Number(min=0.0, max=1.0, def=0.5)
    double alignY;
    @P(value=8)
    @Type.Number(min=0.0, max=8.0, def=1.0, skew=4.0)
    double zoom;
    @P(value=9)
    @Type.String(suggested={"autoaudiosink"})
    @Config.Port(value=false)
    Property audioSink;
    @P(value=10)
    @ReadOnly
    String state;
    @Inject
    VideoPlayer player;
    @AuxOut(value=1)
    Output ready;
    @AuxOut(value=2)
    Output error;
    @AuxOut(value=3)
    Output eos;

    public void init() {
        this.video.linkAs(PResource::from, this.player::location);
        this.rate.link(this.player::rate);
        this.loop.valuesAs(PBoolean.class).link(b -> this.player.looping(b.value()));
        this.play.link(this.player::play);
        this.pause.link(this.player::pause);
        this.stop.link(this.player::stop);
        this.audioSink.linkAs(Value::toString, this.player::audioSink);
        this.player.onReady(() -> ((Output)this.ready).send());
        this.player.onError(msg -> {
            this.log(Constants.ERROR, (String)msg);
            this.error.send(msg);
        });
        this.player.onEOS(() -> ((Output)this.eos).send());
    }

    public void draw() {
        this.position = this.player.render(this::drawFrame) ? this.player.position() : 0.0;
        this.state = this.player.state().toString();
    }

    void drawFrame(PImage frame) {
        double outWidth = this.zoom * (double)frame.width;
        double outHeight = this.zoom * (double)frame.height;
        if (this.resizeMode == ResizeMode.Stretch) {
            outWidth *= (double)this.width / (double)frame.width;
            outHeight *= (double)this.height / (double)frame.height;
        } else if (this.resizeMode == ResizeMode.Scale) {
            double r = this.min((double)this.width / (double)frame.width, (double)this.height / (double)frame.height);
            outWidth *= r;
            outHeight *= r;
        }
        this.image(frame, this.alignX * ((double)this.width - outWidth), this.alignY * ((double)this.height - outHeight), outWidth, outHeight);
    }

    void seek() {
        this.player.position(this.position);
    }

    static enum ResizeMode {
        Stretch,
        Scale,
        Crop;

    }
}

