/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.gstreamer.components;

import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Kernel32;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.freedesktop.gstreamer.Gst;
import org.praxislive.video.gstreamer.configuration.GStreamerSettings;

class GStreamerLibrary {
    private static final GStreamerLibrary INSTANCE = new GStreamerLibrary();

    private GStreamerLibrary() {
        this.initLibraryPaths();
    }

    private void initLibraryPaths() {
        String jnaPath;
        String libPath = GStreamerSettings.getLibraryPath().trim();
        if (libPath.isEmpty()) {
            return;
        }
        if (Platform.isWindows()) {
            try {
                Kernel32 k32 = Kernel32.INSTANCE;
                String path = System.getenv("path");
                if (path == null || path.trim().isEmpty()) {
                    k32.SetEnvironmentVariable("path", libPath);
                } else {
                    k32.SetEnvironmentVariable("path", libPath + File.pathSeparator + path);
                }
                return;
            }
            catch (Throwable e) {
                Logger.getLogger(GStreamerLibrary.class.getName()).log(Level.SEVERE, "Unable to set Windows library path", e);
            }
        }
        if ((jnaPath = System.getProperty("jna.library.path", "").trim()).isEmpty()) {
            System.setProperty("jna.library.path", libPath);
        } else {
            System.setProperty("jna.library.path", jnaPath + File.pathSeparator + libPath);
        }
    }

    void init() {
        Gst.init();
    }

    static GStreamerLibrary getInstance() {
        return INSTANCE;
    }
}

