/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.gstreamer.components;

import org.praxislive.code.userapi.AuxOut;
import org.praxislive.code.userapi.Config;
import org.praxislive.code.userapi.Constants;
import org.praxislive.code.userapi.Inject;
import org.praxislive.code.userapi.Output;
import org.praxislive.code.userapi.P;
import org.praxislive.code.userapi.Property;
import org.praxislive.code.userapi.ReadOnly;
import org.praxislive.code.userapi.T;
import org.praxislive.code.userapi.Trigger;
import org.praxislive.code.userapi.Type;
import org.praxislive.core.Value;
import org.praxislive.video.code.VideoCodeDelegate;
import org.praxislive.video.code.userapi.PImage;
import org.praxislive.video.gstreamer.VideoCapture;

public class VideoCaptureComponent
extends VideoCodeDelegate {
    static final String TEMPLATE_PATH = "resources/video_capture.pxj";
    @T(value=1)
    Trigger play;
    @T(value=2)
    Trigger stop;
    @P(value=1)
    @Type.String(emptyIsDefault=true, suggested={"", "1", "2", "3", "4"})
    Property device;
    @P(value=2)
    ResizeMode resizeMode;
    @P(value=3)
    @Type.Number(min=0.0, max=1.0, def=0.5)
    double alignX;
    @P(value=4)
    @Type.Number(min=0.0, max=1.0, def=0.5)
    double alignY;
    @P(value=5)
    @Type.Number(min=0.0, max=8.0, def=1.0, skew=4.0)
    double zoom;
    @P(value=6)
    @Config.Port(value=false)
    Property sourceWidth;
    @P(value=7)
    @Config.Port(value=false)
    Property sourceHeight;
    @P(value=8)
    @Config.Port(value=false)
    Property sourceFps;
    @P(value=9)
    @ReadOnly
    String state;
    @Inject
    VideoCapture capture;
    @AuxOut(value=1)
    Output ready;
    @AuxOut(value=2)
    Output error;
    @AuxOut(value=3)
    Output eos;

    public void init() {
        this.device.linkAs(Value::toString, this.capture::device);
        this.play.link(() -> this.capture.requestFrameSize(this.I(this.sourceWidth), this.I(this.sourceHeight)).requestFrameRate(this.D(this.sourceFps)).play());
        this.stop.link(this.capture::stop);
        this.capture.onReady(() -> ((Output)this.ready).send());
        this.capture.onError(msg -> {
            this.log(Constants.ERROR, (String)msg);
            this.error.send(msg);
        });
        this.capture.onEOS(() -> ((Output)this.eos).send());
    }

    public void draw() {
        this.capture.render(this::drawFrame);
        this.state = this.capture.state().toString();
    }

    void drawFrame(PImage frame) {
        double outWidth = this.zoom * (double)frame.width;
        double outHeight = this.zoom * (double)frame.height;
        if (this.resizeMode == ResizeMode.Stretch) {
            outWidth *= (double)this.width / (double)frame.width;
            outHeight *= (double)this.height / (double)frame.height;
        } else if (this.resizeMode == ResizeMode.Scale) {
            double r = this.min((double)this.width / (double)frame.width, (double)this.height / (double)frame.height);
            outWidth *= r;
            outHeight *= r;
        }
        this.image(frame, this.alignX * ((double)this.width - outWidth), this.alignY * ((double)this.height - outHeight), outWidth, outHeight);
    }

    static enum ResizeMode {
        Stretch,
        Scale,
        Crop;

    }
}

