/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.gstreamer.components;

import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.freedesktop.gstreamer.Bus;
import org.freedesktop.gstreamer.Gst;
import org.freedesktop.gstreamer.GstObject;
import org.freedesktop.gstreamer.Pipeline;
import org.freedesktop.gstreamer.State;
import org.freedesktop.gstreamer.elements.AppSink;
import org.praxislive.code.CodeConnector;
import org.praxislive.code.CodeContext;
import org.praxislive.code.ReferenceDescriptor;
import org.praxislive.core.services.LogLevel;
import org.praxislive.video.code.userapi.PImage;
import org.praxislive.video.gstreamer.VideoCapture;
import org.praxislive.video.gstreamer.components.PImageSink;
import org.praxislive.video.gstreamer.configuration.GStreamerSettings;

class GStreamerVideoCapture
implements VideoCapture {
    private static final String PIPELINE_END = " ! videorate ! videoscale ! videoconvert ! appsink name=sink";
    private volatile VideoCapture.State state;
    private final AtomicReference<PImageSink> sinkRef;
    private final CodeContext.ClockListener clockListener = this::processMessages;
    private final Queue<Runnable> messages = new ConcurrentLinkedQueue<Runnable>();
    private Pipeline pipeline;
    private CodeContext<?> context;
    private Runnable onReady;
    private Consumer<String> onError;
    private Runnable onEOS;
    private volatile String device = "autovideosrc";

    private GStreamerVideoCapture() {
        this.sinkRef = new AtomicReference();
        this.state = VideoCapture.State.Ready;
        this.buildPipeline(this.device);
    }

    @Override
    public VideoCapture device(String device) {
        boolean changed = !this.device.equals(Objects.requireNonNull(device));
        this.device = device;
        this.async(() -> {
            if (this.pipeline == null || changed) {
                this.buildPipeline(device);
            }
        });
        return this;
    }

    private void buildPipeline(String device) {
        try {
            PImageSink sink;
            if (this.pipeline != null) {
                this.pipeline.stop();
                this.pipeline.dispose();
                this.pipeline = null;
            }
            if ((sink = (PImageSink)this.sinkRef.getAndSet(null)) != null) {
                sink.dispose();
            }
            Object dsc = this.deviceStringToDescription(device);
            dsc = (String)dsc + PIPELINE_END;
            this.pipeline = (Pipeline)Gst.parseLaunch((String)dsc);
            Bus bus = this.pipeline.getBus();
            bus.connect(this::handleError);
            bus.connect(this::handleEOS);
            AppSink appsink = (AppSink)this.pipeline.getElementByName("sink");
            this.sinkRef.set(new PImageSink(appsink));
            this.pipeline.setState(State.READY);
            if (this.pipeline.getState() == State.READY) {
                this.state = VideoCapture.State.Ready;
                this.messages.add(this::messageOnReady);
            } else {
                this.state = VideoCapture.State.Error;
            }
        }
        catch (Exception e) {
            this.state = VideoCapture.State.Error;
        }
    }

    private String deviceStringToDescription(String device) {
        if ((device = device.trim()).isEmpty()) {
            device = "autovideosrc";
        } else if (device.length() == 1) {
            try {
                device = GStreamerSettings.getCaptureDevice(Integer.valueOf(device));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return device;
    }

    public String device() {
        return this.device;
    }

    @Override
    public VideoCapture play() {
        this.async(() -> {
            if (this.state != VideoCapture.State.Playing) {
                this.state = VideoCapture.State.Playing;
                if (this.pipeline == null) {
                    this.buildPipeline(this.device);
                }
                this.pipeline.play();
            }
        });
        return this;
    }

    @Override
    public VideoCapture stop() {
        this.async(() -> {
            PImageSink sink;
            this.state = VideoCapture.State.Ready;
            if (this.pipeline != null) {
                this.pipeline.stop();
            }
            if ((sink = this.sinkRef.get()) != null) {
                sink.dispose();
            }
        });
        return this;
    }

    @Override
    public VideoCapture.State state() {
        return this.state;
    }

    @Override
    public boolean render(Consumer<PImage> renderer) {
        PImageSink sink;
        if (this.state == VideoCapture.State.Playing && (sink = this.sinkRef.get()) != null) {
            return sink.render(renderer);
        }
        return false;
    }

    @Override
    public VideoCapture onReady(Runnable ready) {
        this.onReady = ready;
        return this;
    }

    @Override
    public VideoCapture onError(Consumer<String> error) {
        this.onError = error;
        return this;
    }

    @Override
    public VideoCapture onEOS(Runnable eos) {
        this.onEOS = eos;
        return this;
    }

    @Override
    public VideoCapture requestFrameSize(int width, int height) {
        this.async(() -> {
            PImageSink sink = this.sinkRef.get();
            if (sink != null) {
                sink.requestFrameSize(width, height);
            }
        });
        return this;
    }

    @Override
    public VideoCapture requestFrameRate(double fps) {
        this.async(() -> {
            PImageSink sink = this.sinkRef.get();
            if (sink != null) {
                sink.requestFrameRate(fps);
            }
        });
        return this;
    }

    private void handleError(GstObject source, int code, String message) {
        this.async(() -> {
            this.state = VideoCapture.State.Error;
            this.pipeline.stop();
            this.pipeline.dispose();
            this.pipeline = null;
            this.messages.add(() -> this.messageOnError(message));
        });
    }

    private void handleEOS(GstObject source) {
        this.stop();
        this.messages.add(this::messageOnEOS);
    }

    private void attach(CodeContext<?> context) {
        if (this.context != null) {
            this.context.removeClockListener(this.clockListener);
        }
        this.context = context;
        this.context.addClockListener(this.clockListener);
    }

    private void reset(boolean full) {
        this.onReady = null;
        this.onError = null;
        this.onEOS = null;
        if (full) {
            this.messages.clear();
            this.state = VideoCapture.State.Ready;
            this.async(this::disposePipeline);
        }
    }

    private void dispose() {
        this.async(this::disposePipeline);
        this.messages.clear();
        if (this.context != null) {
            this.context.removeClockListener(this.clockListener);
            this.context = null;
        }
    }

    private void disposePipeline() {
        PImageSink sink;
        if (this.pipeline != null) {
            this.pipeline.stop();
            this.pipeline.dispose();
            this.pipeline = null;
        }
        if ((sink = (PImageSink)this.sinkRef.getAndSet(null)) != null) {
            sink.dispose();
        }
    }

    private void async(Runnable task) {
        Gst.getExecutor().execute(task);
    }

    private void processMessages() {
        Runnable message;
        while ((message = this.messages.poll()) != null) {
            message.run();
        }
    }

    private void messageOnReady() {
        if (this.onReady != null) {
            this.onReady.run();
        }
    }

    private void messageOnError(String details) {
        if (this.onError != null) {
            this.onError.accept(details);
        }
    }

    private void messageOnEOS() {
        if (this.onEOS != null) {
            this.onEOS.run();
        }
    }

    static class Descriptor
    extends ReferenceDescriptor<Descriptor> {
        private final Field field;
        private GStreamerVideoCapture capture;

        private Descriptor(String id, Field field) {
            super(Descriptor.class, id);
            this.field = field;
        }

        public void attach(CodeContext<?> context, Descriptor previous) {
            if (previous != null) {
                this.capture = previous.capture;
                previous.capture = null;
            }
            if (this.capture == null) {
                this.capture = new GStreamerVideoCapture();
            }
            this.capture.attach(context);
            try {
                this.field.set(context.getDelegate(), this.capture);
            }
            catch (Exception ex) {
                context.getLog().log(LogLevel.ERROR, ex);
            }
        }

        public void onReset() {
            this.capture.reset(false);
        }

        public void onStop() {
            this.capture.reset(true);
        }

        public void dispose() {
            this.capture.dispose();
        }

        static Descriptor create(CodeConnector<?> connector, Field field) {
            if (field.getType() == VideoCapture.class) {
                field.setAccessible(true);
                return new Descriptor(field.getName(), field);
            }
            return null;
        }
    }
}

