/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.gstreamer.components;

import java.io.File;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.freedesktop.gstreamer.Bus;
import org.freedesktop.gstreamer.Element;
import org.freedesktop.gstreamer.ElementFactory;
import org.freedesktop.gstreamer.Format;
import org.freedesktop.gstreamer.Gst;
import org.freedesktop.gstreamer.GstObject;
import org.freedesktop.gstreamer.State;
import org.freedesktop.gstreamer.elements.PlayBin;
import org.freedesktop.gstreamer.event.SeekFlags;
import org.freedesktop.gstreamer.event.SeekType;
import org.praxislive.code.CodeConnector;
import org.praxislive.code.CodeContext;
import org.praxislive.code.ReferenceDescriptor;
import org.praxislive.core.Lookup;
import org.praxislive.core.services.LogLevel;
import org.praxislive.core.types.PResource;
import org.praxislive.video.code.userapi.PImage;
import org.praxislive.video.gstreamer.VideoPlayer;
import org.praxislive.video.gstreamer.components.PImageSink;

class GStreamerVideoPlayer
implements VideoPlayer {
    private volatile VideoPlayer.State state = VideoPlayer.State.Empty;
    private final PlayBin playbin = new PlayBin("playbin");
    private final PImageSink sink = new PImageSink();
    private final CodeContext.ClockListener clockListener;
    private final Queue<Runnable> messages;
    private CodeContext<?> context;
    private Runnable onReady;
    private Consumer<String> onError;
    private Runnable onEOS;
    private volatile Optional<PResource> location;
    private volatile String audioSink;
    private volatile boolean looping;
    private volatile double rate;

    private GStreamerVideoPlayer() {
        this.playbin.setVideoSink((Element)this.sink.getElement());
        this.audioSink = "";
        this.looping = false;
        this.rate = 1.0;
        this.location = Optional.empty();
        this.clockListener = this::processMessages;
        this.messages = new ConcurrentLinkedQueue<Runnable>();
        Bus bus = this.playbin.getBus();
        bus.connect(this::handleError);
        bus.connect(this::handleEOS);
        this.configureAudioSink();
    }

    @Override
    public VideoPlayer location(Optional<PResource> location) {
        if (!this.location.equals(Objects.requireNonNull(location))) {
            this.location = location;
            Lookup lkp = this.context.getLookup();
            this.async(() -> {
                URI loc = this.resolve(location, lkp);
                if (loc != null) {
                    this.playbin.stop();
                    this.sink.dispose();
                    this.playbin.setURI(loc);
                    this.playbin.setState(State.READY);
                    if (this.playbin.getState() == State.READY) {
                        this.state = VideoPlayer.State.Ready;
                        this.messages.add(this::messageOnReady);
                    } else {
                        this.state = VideoPlayer.State.Error;
                    }
                } else {
                    this.playbin.stop();
                    this.state = VideoPlayer.State.Empty;
                }
            });
        }
        return this;
    }

    public Optional<PResource> location() {
        return this.location;
    }

    @Override
    public VideoPlayer play() {
        this.async(() -> {
            if (this.state != VideoPlayer.State.Playing && this.location.isPresent()) {
                this.state = VideoPlayer.State.Playing;
                this.playbin.play();
                double r = this.rate;
                if (r != 1.0) {
                    this.playbin.getState();
                    this.handleSeek(false, -1L);
                }
            }
        });
        return this;
    }

    @Override
    public VideoPlayer pause() {
        this.async(() -> {
            if (this.location.isPresent()) {
                this.state = VideoPlayer.State.Paused;
                this.playbin.pause();
            }
        });
        return this;
    }

    @Override
    public VideoPlayer stop() {
        this.async(() -> {
            if (this.location.isPresent()) {
                this.state = VideoPlayer.State.Empty;
                this.playbin.stop();
                this.sink.dispose();
            }
        });
        return this;
    }

    @Override
    public VideoPlayer.State state() {
        return this.state;
    }

    @Override
    public VideoPlayer position(double position) {
        this.async(() -> {
            long dur;
            if ((this.state == VideoPlayer.State.Playing || this.state == VideoPlayer.State.Paused) && (dur = this.playbin.queryDuration(TimeUnit.NANOSECONDS)) > 0L) {
                long pos = (long)(position * (double)dur);
                this.handleSeek(false, pos);
            }
        });
        return this;
    }

    @Override
    public double position() {
        if (this.state == VideoPlayer.State.Playing || this.state == VideoPlayer.State.Paused) {
            double value;
            long pos = this.playbin.queryPosition(TimeUnit.NANOSECONDS);
            long dur = this.playbin.queryDuration(TimeUnit.NANOSECONDS);
            double d = value = dur > 0L ? (double)pos / (double)dur : 0.0;
            return value < 0.0 ? 0.0 : (value > 1.0 ? 0.0 : value);
        }
        return 0.0;
    }

    @Override
    public double duration() {
        if (this.state == VideoPlayer.State.Playing || this.state == VideoPlayer.State.Paused) {
            return (double)this.playbin.queryDuration(TimeUnit.NANOSECONDS) / 1.0E9;
        }
        return 0.0;
    }

    @Override
    public VideoPlayer looping(boolean looping) {
        this.looping = looping;
        return this;
    }

    public boolean looping() {
        return this.looping;
    }

    @Override
    public VideoPlayer rate(double rate) {
        if (rate != this.rate) {
            this.rate = rate;
            this.async(() -> this.handleSeek(false, -1L));
        }
        return this;
    }

    public double rate() {
        return this.rate;
    }

    @Override
    public boolean render(Consumer<PImage> renderer) {
        if (this.state == VideoPlayer.State.Playing || this.state == VideoPlayer.State.Paused) {
            return this.sink.render(renderer);
        }
        return false;
    }

    @Override
    public void audioSink(String audioSink) {
        if (!this.audioSink.equals(Objects.requireNonNull(audioSink))) {
            this.audioSink = audioSink;
            this.async(this::configureAudioSink);
        }
    }

    public String audioSink() {
        return this.audioSink;
    }

    @Override
    public VideoPlayer onReady(Runnable ready) {
        this.onReady = ready;
        return this;
    }

    @Override
    public VideoPlayer onError(Consumer<String> error) {
        this.onError = error;
        return this;
    }

    @Override
    public VideoPlayer onEOS(Runnable eos) {
        this.onEOS = eos;
        return this;
    }

    private void handleError(GstObject source, int code, String message) {
        this.async(() -> {
            this.state = VideoPlayer.State.Error;
            this.playbin.stop();
            this.messages.add(() -> this.messageOnError(message));
        });
    }

    private void handleEOS(GstObject source) {
        if (this.looping) {
            this.async(() -> this.handleSeek(true, -1L));
        } else {
            this.stop();
        }
        this.messages.add(this::messageOnEOS);
    }

    private void handleSeek(boolean eos, long position) {
        VideoPlayer.State s = this.state;
        if (s == VideoPlayer.State.Playing || s == VideoPlayer.State.Paused) {
            double rate = this.rate;
            if (rate == 0.0) {
                rate = 1.0E-7;
            }
            if (eos) {
                position = rate > 0.0 ? 0L : this.playbin.queryDuration(TimeUnit.NANOSECONDS);
            } else if (position < 0L) {
                position = this.playbin.queryPosition(TimeUnit.NANOSECONDS);
            }
            if (rate > 0.0) {
                this.playbin.seek(rate, Format.TIME, EnumSet.of(SeekFlags.FLUSH, SeekFlags.ACCURATE), SeekType.SET, position, SeekType.NONE, -1L);
            } else {
                this.playbin.seek(rate, Format.TIME, EnumSet.of(SeekFlags.FLUSH, SeekFlags.ACCURATE), SeekType.SET, 0L, SeekType.SET, position);
            }
        }
        this.playbin.getState(10L, TimeUnit.MILLISECONDS);
    }

    private URI resolve(Optional<PResource> location, Lookup lookup) {
        if (location.isPresent()) {
            PResource res = location.get();
            List uris = res.resolve(lookup);
            for (URI uri : uris) {
                if ("file".equals(uri.getScheme())) {
                    try {
                        if (!new File(uri).exists()) continue;
                        return uri;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                return uri;
            }
        }
        return null;
    }

    private void configureAudioSink() {
        String audio = this.audioSink.trim();
        int flags = (Integer)this.playbin.get("flags");
        if (audio.isEmpty()) {
            flags &= 0xFFFFFFFD;
            this.playbin.setAudioSink(ElementFactory.make((String)"fakesink", (String)"fakesink"));
        } else {
            flags |= 2;
            this.playbin.setAudioSink((Element)Gst.parseBinFromDescription((String)audio, (boolean)true));
        }
        this.playbin.set("flags", (Object)flags);
    }

    private void attach(CodeContext<?> context) {
        if (this.context != null) {
            this.context.removeClockListener(this.clockListener);
        }
        this.context = context;
        this.context.addClockListener(this.clockListener);
    }

    private void reset(boolean full) {
        this.onReady = null;
        this.onError = null;
        this.onEOS = null;
        if (full) {
            this.stop();
            this.messages.clear();
        }
    }

    private void dispose() {
        this.async(() -> {
            this.playbin.stop();
            this.playbin.getBus().dispose();
            this.playbin.dispose();
        });
        this.messages.clear();
        if (this.context != null) {
            this.context.removeClockListener(this.clockListener);
            this.context = null;
        }
    }

    private void async(Runnable task) {
        Gst.getExecutor().execute(task);
    }

    private void processMessages() {
        Runnable message;
        while ((message = this.messages.poll()) != null) {
            message.run();
        }
    }

    private void messageOnReady() {
        if (this.onReady != null) {
            this.onReady.run();
        }
    }

    private void messageOnError(String details) {
        if (this.onError != null) {
            this.onError.accept(details);
        }
    }

    private void messageOnEOS() {
        if (this.onEOS != null) {
            this.onEOS.run();
        }
    }

    static class Descriptor
    extends ReferenceDescriptor<Descriptor> {
        private final Field field;
        private GStreamerVideoPlayer player;

        private Descriptor(String id, Field field) {
            super(Descriptor.class, id);
            this.field = field;
        }

        public void attach(CodeContext<?> context, Descriptor previous) {
            if (previous != null) {
                this.player = previous.player;
                previous.player = null;
            }
            if (this.player == null) {
                this.player = new GStreamerVideoPlayer();
            }
            this.player.attach(context);
            try {
                this.field.set(context.getDelegate(), this.player);
            }
            catch (Exception ex) {
                context.getLog().log(LogLevel.ERROR, ex);
            }
        }

        public void onReset() {
            this.player.reset(false);
        }

        public void onStop() {
            this.player.reset(true);
        }

        public void dispose() {
            this.player.dispose();
        }

        static Descriptor create(CodeConnector<?> connector, Field field) {
            if (field.getType() == VideoPlayer.class) {
                field.setAccessible(true);
                return new Descriptor(field.getName(), field);
            }
            return null;
        }
    }
}

