/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video;

import org.praxislive.core.Settings;

public class VideoSettings {
    private static final String KEY_FULLSCREENMODE = "video.fullscreenmode";
    private static final boolean DEFAULT_FSEM;

    private VideoSettings() {
    }

    public static void setFullScreenMode(FullScreenMode mode) {
        if (mode == FullScreenMode.Default) {
            Settings.put((String)KEY_FULLSCREENMODE, null);
        } else {
            Settings.put((String)KEY_FULLSCREENMODE, (String)mode.name());
        }
    }

    public static FullScreenMode getFullScreenMode() {
        String m = Settings.get((String)KEY_FULLSCREENMODE);
        if (m != null) {
            try {
                return FullScreenMode.valueOf(m);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return FullScreenMode.Default;
    }

    public static boolean isFullScreenExclusive() {
        switch (VideoSettings.getFullScreenMode()) {
            case Exclusive: {
                return true;
            }
            case Fake: {
                return false;
            }
        }
        return DEFAULT_FSEM;
    }

    static {
        String os = System.getProperty("os.name", "");
        DEFAULT_FSEM = os.contains("Windows") ? false : (os.contains("Mac") || os.contains("Darwin") ? true : true);
    }

    public static enum FullScreenMode {
        Default,
        Exclusive,
        Fake;

    }
}

