/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.pipes.impl;

import java.util.ArrayList;
import java.util.List;
import org.praxislive.video.pipes.SourceIsFullException;
import org.praxislive.video.pipes.VideoPipe;
import org.praxislive.video.render.Surface;

public abstract class MultiInOut
extends VideoPipe {
    private int maxSources;
    private List<VideoPipe> sources;
    private int maxSinks;
    private List<VideoPipe> sinks;
    private Surface[] inputs;
    private long time;
    private long renderReqTime;
    private boolean renderReqCache;
    private int renderIdx = 0;

    protected MultiInOut(int maxSources, int maxSinks) {
        if (maxSources < 0 || maxSinks < 1) {
            throw new IllegalArgumentException();
        }
        this.maxSources = maxSources;
        this.sources = new ArrayList<VideoPipe>();
        this.maxSinks = maxSinks;
        this.sinks = new ArrayList<VideoPipe>();
        this.inputs = new Surface[0];
    }

    @Override
    protected final void process(VideoPipe sink, Surface output, long time) {
        int sinkIndex = this.sinks.indexOf(sink);
        if (sinkIndex < 0) {
            return;
        }
        if (this.time != time) {
            this.time = time;
            this.checkBuffers(output);
            this.callSources(time);
            this.processInputs(this.inputs, this.isRendering(time));
        }
        this.process(this.inputs, output, sinkIndex, this.sinkRequiresRender(sink, time));
    }

    private void checkBuffers(Surface out) {
        if (this.inputs.length != this.sources.size()) {
            Surface[] newBufs;
            System.arraycopy(this.inputs, 0, newBufs, 0, this.inputs.length < (newBufs = new Surface[this.sources.size()]).length ? this.inputs.length : newBufs.length);
            this.inputs = newBufs;
        }
        for (int i = 0; i < this.inputs.length; ++i) {
            this.inputs[i] = this.validateInput(this.inputs[i], out, i);
        }
    }

    protected Surface validateInput(Surface input, Surface output, int index) {
        if (input == null || !output.checkCompatible(input, true, true)) {
            if (input != null) {
                input.release();
            }
            input = output.createSurface();
        }
        return input;
    }

    private void callSources(long time) {
        for (int i = 0; i < this.sources.size(); ++i) {
            this.callSource(this.sources.get(i), this.inputs[i], time);
        }
    }

    protected void processInputs(Surface[] inputs, boolean rendering) {
    }

    protected abstract void process(Surface[] var1, Surface var2, int var3, boolean var4);

    protected long getTime() {
        return this.time;
    }

    @Override
    protected void registerSink(VideoPipe sink) throws SourceIsFullException {
        if (sink == null) {
            throw new NullPointerException();
        }
        if (this.sinks.contains(sink)) {
            throw new IllegalArgumentException();
        }
        if (this.sinks.size() == this.maxSinks) {
            throw new SourceIsFullException();
        }
        this.sinks.add(sink);
    }

    @Override
    protected void unregisterSink(VideoPipe sink) {
        this.sinks.remove(sink);
    }

    @Override
    protected void registerSource(VideoPipe source) {
        if (source == null) {
            throw new NullPointerException();
        }
        if (this.sources.contains(source)) {
            throw new IllegalArgumentException();
        }
        if (this.sources.size() == this.maxSources) {
            throw new SourceIsFullException();
        }
        this.sources.add(source);
    }

    @Override
    public void unregisterSource(VideoPipe source) {
        this.sources.remove(source);
    }

    @Override
    protected boolean isRenderRequired(VideoPipe source, long time) {
        return this.isRendering(time);
    }

    private boolean isRendering(long time) {
        if (this.sinks.size() == 1) {
            return this.simpleRenderingCheck(time);
        }
        return this.protectedRenderingCheck(time);
    }

    private boolean simpleRenderingCheck(long time) {
        if (time != this.renderReqTime) {
            this.renderReqTime = time;
            this.renderReqCache = this.sinkRequiresRender(this.sinks.get(0), time);
        }
        return this.renderReqCache;
    }

    private boolean protectedRenderingCheck(long time) {
        if (this.renderIdx > 0) {
            while (this.renderIdx < this.sinks.size()) {
                VideoPipe sink = this.sinks.get(this.renderIdx);
                ++this.renderIdx;
                if (!this.sinkRequiresRender(sink, time)) continue;
                this.renderIdx = 0;
                return true;
            }
            return false;
        }
        if (this.renderReqTime != time) {
            this.renderReqTime = time;
            this.renderReqCache = false;
            while (this.renderIdx < this.sinks.size()) {
                VideoPipe sink = this.sinks.get(this.renderIdx);
                ++this.renderIdx;
                if (!this.sinkRequiresRender(sink, time)) continue;
                this.renderReqCache = true;
                break;
            }
            this.renderIdx = 0;
        }
        return this.renderReqCache;
    }

    @Override
    public int getSourceCount() {
        return this.sources.size();
    }

    @Override
    public int getSourceCapacity() {
        return this.maxSources;
    }

    @Override
    public VideoPipe getSource(int idx) {
        return this.sources.get(idx);
    }

    @Override
    public int getSinkCount() {
        return this.sinks.size();
    }

    @Override
    public int getSinkCapacity() {
        return this.maxSinks;
    }

    @Override
    public VideoPipe getSink(int idx) {
        return this.sinks.get(idx);
    }
}

