/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.render.ops;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.praxislive.video.render.PixelData;
import org.praxislive.video.render.SurfaceOp;
import org.praxislive.video.render.utils.ImageUtils;

public class GraphicsOp
implements SurfaceOp {
    private static final Image[] EMPTY = new Image[0];
    private Callback callback;

    public GraphicsOp(Callback callback) {
        if (callback == null) {
            throw new NullPointerException();
        }
        this.callback = callback;
    }

    @Override
    public void process(PixelData output, PixelData ... inputs) {
        Image[] srcs;
        BufferedImage dst = ImageUtils.toImage(output);
        if (inputs.length == 0) {
            srcs = EMPTY;
        } else {
            srcs = new Image[inputs.length];
            for (int i = 0; i < inputs.length; ++i) {
                srcs[i] = ImageUtils.toImage(inputs[i]);
            }
        }
        Graphics2D g2d = dst.createGraphics();
        this.callback.draw(g2d, srcs);
        g2d.dispose();
    }

    public Callback getCallback() {
        return this.callback;
    }

    public static interface Callback {
        public void draw(Graphics2D var1, Image[] var2);
    }
}

