/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.render.ops;

import org.praxislive.video.render.utils.RGBMath;

abstract class RGBComposite {
    static final RGBComposite ADD = new Add();
    static final RGBComposite BITXOR = new BitXor();
    static final RGBComposite DIFFERENCE = new Difference();
    static final RGBComposite MASK = new Mask();
    static final RGBComposite MULTIPLY = new Multiply();
    static final RGBComposite NORMAL = new Normal();
    static final RGBComposite SCREEN = new Screen();
    static final RGBComposite SUB = new Sub();

    private RGBComposite() {
    }

    abstract void rgb(int[] var1, int var2, int[] var3, int var4, int var5, int var6);

    abstract void argb(int[] var1, int var2, int[] var3, int var4, int var5, int var6);

    static class Mask
    extends RGBComposite {
        private Mask() {
        }

        @Override
        void rgb(int[] src, int srcPos, int[] dest, int destPos, int length, int alpha) {
            for (int i = 0; i < length; ++i) {
                int srcPx = src[srcPos];
                int destPx = dest[destPos];
                int srcR = alpha == 255 ? (srcPx & 0xFF0000) >>> 16 : RGBMath.mult((srcPx & 0xFF0000) >>> 16, alpha);
                int srcG = alpha == 255 ? (srcPx & 0xFF00) >>> 8 : RGBMath.mult((srcPx & 0xFF00) >>> 8, alpha);
                int srcB = alpha == 255 ? srcPx & 0xFF : RGBMath.mult(srcPx & 0xFF, alpha);
                int destR = (destPx & 0xFF0000) >>> 16;
                int destG = (destPx & 0xFF00) >>> 8;
                int destB = destPx & 0xFF;
                dest[destPos] = alpha == 255 ? RGBMath.mult(srcR, destR) << 16 | RGBMath.mult(srcG, destG) << 8 | RGBMath.mult(srcB, destB) : RGBMath.mult(srcR, destR) + RGBMath.mult(destR, 255 - alpha) << 16 | RGBMath.mult(srcG, destG) + RGBMath.mult(destG, 255 - alpha) << 8 | RGBMath.mult(srcB, destB) + RGBMath.mult(destB, 255 - alpha);
                ++srcPos;
                ++destPos;
            }
        }

        @Override
        void argb(int[] src, int srcPos, int[] dest, int destPos, int length, int alpha) {
            for (int i = 0; i < length; ++i) {
                int srcPx = src[srcPos];
                int destPx = dest[destPos];
                int srcA = alpha == 255 ? (srcPx & 0xFF000000) >>> 24 : RGBMath.mult((srcPx & 0xFF000000) >>> 24, alpha);
                int srcR = alpha == 255 ? (srcPx & 0xFF0000) >>> 16 : RGBMath.mult((srcPx & 0xFF0000) >>> 16, alpha);
                int srcG = alpha == 255 ? (srcPx & 0xFF00) >>> 8 : RGBMath.mult((srcPx & 0xFF00) >>> 8, alpha);
                int srcB = alpha == 255 ? srcPx & 0xFF : RGBMath.mult(srcPx & 0xFF, alpha);
                int destA = (destPx & 0xFF000000) >>> 24;
                int destR = (destPx & 0xFF0000) >>> 16;
                int destG = (destPx & 0xFF00) >>> 8;
                int destB = destPx & 0xFF;
                dest[destPos] = alpha == 255 ? RGBMath.mult(srcA, destA) << 24 | RGBMath.mult(srcR, destR) << 16 | RGBMath.mult(srcG, destG) << 8 | RGBMath.mult(srcB, destB) : RGBMath.mult(srcA, destA) + RGBMath.mult(destA, 255 - alpha) << 24 | RGBMath.mult(srcR, destR) + RGBMath.mult(destR, 255 - alpha) << 16 | RGBMath.mult(srcG, destG) + RGBMath.mult(destG, 255 - alpha) << 8 | RGBMath.mult(srcB, destB) + RGBMath.mult(destB, 255 - alpha);
                ++srcPos;
                ++destPos;
            }
        }
    }

    static class Multiply
    extends RGBComposite {
        private Multiply() {
        }

        @Override
        void rgb(int[] src, int srcPos, int[] dest, int destPos, int length, int alpha) {
            for (int i = 0; i < length; ++i) {
                int srcPx = src[srcPos];
                int destPx = dest[destPos];
                int srcR = alpha == 255 ? (srcPx & 0xFF0000) >>> 16 : RGBMath.mult((srcPx & 0xFF0000) >>> 16, alpha);
                int srcG = alpha == 255 ? (srcPx & 0xFF00) >>> 8 : RGBMath.mult((srcPx & 0xFF00) >>> 8, alpha);
                int srcB = alpha == 255 ? srcPx & 0xFF : RGBMath.mult(srcPx & 0xFF, alpha);
                int destR = (destPx & 0xFF0000) >>> 16;
                int destG = (destPx & 0xFF00) >>> 8;
                int destB = destPx & 0xFF;
                dest[destPos] = alpha == 255 ? RGBMath.mult(srcR, destR) << 16 | RGBMath.mult(srcG, destG) << 8 | RGBMath.mult(srcB, destB) : RGBMath.mult(srcR, destR) + RGBMath.mult(destR, 255 - alpha) << 16 | RGBMath.mult(srcG, destG) + RGBMath.mult(destG, 255 - alpha) << 8 | RGBMath.mult(srcB, destB) + RGBMath.mult(destB, 255 - alpha);
                ++srcPos;
                ++destPos;
            }
        }

        @Override
        public void argb(int[] src, int srcPos, int[] dest, int destPos, int length, int alpha) {
            for (int i = 0; i < length; ++i) {
                int srcPx = src[srcPos];
                int destPx = dest[destPos];
                int srcA = alpha == 255 ? (srcPx & 0xFF000000) >>> 24 : RGBMath.mult((srcPx & 0xFF000000) >>> 24, alpha);
                int srcR = alpha == 255 ? (srcPx & 0xFF0000) >>> 16 : RGBMath.mult((srcPx & 0xFF0000) >>> 16, alpha);
                int srcG = alpha == 255 ? (srcPx & 0xFF00) >>> 8 : RGBMath.mult((srcPx & 0xFF00) >>> 8, alpha);
                int srcB = alpha == 255 ? srcPx & 0xFF : RGBMath.mult(srcPx & 0xFF, alpha);
                int destA = (destPx & 0xFF000000) >>> 24;
                int destR = (destPx & 0xFF0000) >>> 16;
                int destG = (destPx & 0xFF00) >>> 8;
                int destB = destPx & 0xFF;
                dest[destPos] = RGBMath.blend(srcA, destA, srcA) << 24 | RGBMath.mult(srcR, destR) + RGBMath.mult(destR, 255 - srcA) + RGBMath.mult(srcR, 255 - destA) << 16 | RGBMath.mult(srcG, destG) + RGBMath.mult(destG, 255 - srcA) + RGBMath.mult(srcG, 255 - destA) << 8 | RGBMath.mult(srcB, destB) + RGBMath.mult(destB, 255 - srcA) + RGBMath.mult(srcB, 255 - destA);
                ++srcPos;
                ++destPos;
            }
        }
    }

    static class Screen
    extends RGBComposite {
        private Screen() {
        }

        @Override
        void rgb(int[] src, int srcPos, int[] dest, int destPos, int length, int alpha) {
            for (int i = 0; i < length; ++i) {
                int srcPx = src[srcPos];
                int destPx = dest[destPos];
                int srcR = alpha == 255 ? (srcPx & 0xFF0000) >>> 16 : RGBMath.mult((srcPx & 0xFF0000) >>> 16, alpha);
                int srcG = alpha == 255 ? (srcPx & 0xFF00) >>> 8 : RGBMath.mult((srcPx & 0xFF00) >>> 8, alpha);
                int srcB = alpha == 255 ? srcPx & 0xFF : RGBMath.mult(srcPx & 0xFF, alpha);
                int destR = (destPx & 0xFF0000) >>> 16;
                int destG = (destPx & 0xFF00) >>> 8;
                int destB = destPx & 0xFF;
                dest[destPos] = 255 - RGBMath.mult(255 - srcR, 255 - destR) << 16 | 255 - RGBMath.mult(255 - srcG, 255 - destG) << 8 | 255 - RGBMath.mult(255 - srcB, 255 - destB);
                ++srcPos;
                ++destPos;
            }
        }

        @Override
        void argb(int[] src, int srcPos, int[] dest, int destPos, int length, int alpha) {
            for (int i = 0; i < length; ++i) {
                int srcPx = src[srcPos];
                int destPx = dest[destPos];
                int srcA = alpha == 255 ? (srcPx & 0xFF000000) >>> 24 : RGBMath.mult((srcPx & 0xFF000000) >>> 24, alpha);
                int srcR = alpha == 255 ? (srcPx & 0xFF0000) >>> 16 : RGBMath.mult((srcPx & 0xFF0000) >>> 16, alpha);
                int srcG = alpha == 255 ? (srcPx & 0xFF00) >>> 8 : RGBMath.mult((srcPx & 0xFF00) >>> 8, alpha);
                int srcB = alpha == 255 ? srcPx & 0xFF : RGBMath.mult(srcPx & 0xFF, alpha);
                int destA = (destPx & 0xFF000000) >>> 24;
                int destR = (destPx & 0xFF0000) >>> 16;
                int destG = (destPx & 0xFF00) >>> 8;
                int destB = destPx & 0xFF;
                dest[destPos] = RGBMath.blend(srcA, destA, srcA) << 24 | 255 - RGBMath.mult(255 - srcR, 255 - destR) << 16 | 255 - RGBMath.mult(255 - srcG, 255 - destG) << 8 | 255 - RGBMath.mult(255 - srcB, 255 - destB);
                ++srcPos;
                ++destPos;
            }
        }
    }

    static class BitXor
    extends RGBComposite {
        private BitXor() {
        }

        @Override
        void rgb(int[] src, int srcPos, int[] dest, int destPos, int length, int alpha) {
            for (int i = 0; i < length; ++i) {
                int srcPx = src[srcPos];
                int destPx = dest[destPos];
                int srcR = alpha == 255 ? (srcPx & 0xFF0000) >>> 16 : RGBMath.mult((srcPx & 0xFF0000) >>> 16, alpha);
                int srcG = alpha == 255 ? (srcPx & 0xFF00) >>> 8 : RGBMath.mult((srcPx & 0xFF00) >>> 8, alpha);
                int srcB = alpha == 255 ? srcPx & 0xFF : RGBMath.mult(srcPx & 0xFF, alpha);
                int destR = (destPx & 0xFF0000) >>> 16;
                int destG = (destPx & 0xFF00) >>> 8;
                int destB = destPx & 0xFF;
                dest[destPos] = (srcR ^ destR) << 16 | (srcG ^ destG) << 8 | srcB ^ destB;
                ++srcPos;
                ++destPos;
            }
        }

        @Override
        void argb(int[] src, int srcPos, int[] dest, int destPos, int length, int alpha) {
            for (int i = 0; i < length; ++i) {
                int srcPx = src[srcPos];
                int destPx = dest[destPos];
                int srcA = alpha == 255 ? (srcPx & 0xFF000000) >>> 24 : RGBMath.mult((srcPx & 0xFF000000) >>> 24, alpha);
                int srcR = alpha == 255 ? (srcPx & 0xFF0000) >>> 16 : RGBMath.mult((srcPx & 0xFF0000) >>> 16, alpha);
                int srcG = alpha == 255 ? (srcPx & 0xFF00) >>> 8 : RGBMath.mult((srcPx & 0xFF00) >>> 8, alpha);
                int srcB = alpha == 255 ? srcPx & 0xFF : RGBMath.mult(srcPx & 0xFF, alpha);
                int destA = (destPx & 0xFF000000) >>> 24;
                int destR = (destPx & 0xFF0000) >>> 16;
                int destG = (destPx & 0xFF00) >>> 8;
                int destB = destPx & 0xFF;
                dest[destPos] = RGBMath.blend(srcA, destA, srcA) << 24 | (srcR ^ destR) << 16 | (srcG ^ destG) << 8 | srcB ^ destB;
                ++srcPos;
                ++destPos;
            }
        }
    }

    static class Difference
    extends RGBComposite {
        private Difference() {
        }

        @Override
        void rgb(int[] src, int srcPos, int[] dest, int destPos, int length, int alpha) {
            for (int i = 0; i < length; ++i) {
                int srcPx = src[srcPos];
                int destPx = dest[destPos];
                int srcR = alpha == 255 ? (srcPx & 0xFF0000) >>> 16 : RGBMath.mult((srcPx & 0xFF0000) >>> 16, alpha);
                int srcG = alpha == 255 ? (srcPx & 0xFF00) >>> 8 : RGBMath.mult((srcPx & 0xFF00) >>> 8, alpha);
                int srcB = alpha == 255 ? srcPx & 0xFF : RGBMath.mult(srcPx & 0xFF, alpha);
                int destR = (destPx & 0xFF0000) >>> 16;
                int destG = (destPx & 0xFF00) >>> 8;
                int destB = destPx & 0xFF;
                dest[destPos] = alpha == 255 ? RGBMath.diff(srcR, destR) << 16 | RGBMath.diff(srcG, destG) << 8 | RGBMath.diff(srcB, destB) : srcR + destR - 2 * RGBMath.min(srcR, RGBMath.mult(destR, alpha)) << 16 | srcG + destG - 2 * RGBMath.min(srcG, RGBMath.mult(destG, alpha)) << 8 | srcB + destB - 2 * RGBMath.min(srcB, RGBMath.mult(destB, alpha));
                ++srcPos;
                ++destPos;
            }
        }

        @Override
        void argb(int[] src, int srcPos, int[] dest, int destPos, int length, int alpha) {
            for (int i = 0; i < length; ++i) {
                int srcPx = src[srcPos];
                int destPx = dest[destPos];
                int srcA = alpha == 255 ? (srcPx & 0xFF000000) >>> 24 : RGBMath.mult((srcPx & 0xFF000000) >>> 24, alpha);
                int srcR = alpha == 255 ? (srcPx & 0xFF0000) >>> 16 : RGBMath.mult((srcPx & 0xFF0000) >>> 16, alpha);
                int srcG = alpha == 255 ? (srcPx & 0xFF00) >>> 8 : RGBMath.mult((srcPx & 0xFF00) >>> 8, alpha);
                int srcB = alpha == 255 ? srcPx & 0xFF : RGBMath.mult(srcPx & 0xFF, alpha);
                int destA = (destPx & 0xFF000000) >>> 24;
                int destR = (destPx & 0xFF0000) >>> 16;
                int destG = (destPx & 0xFF00) >>> 8;
                int destB = destPx & 0xFF;
                dest[destPos] = RGBMath.blend(srcA, destA, srcA) << 24 | srcR + destR - 2 * RGBMath.min(RGBMath.mult(srcR, destA), RGBMath.mult(destR, srcA)) << 16 | srcG + destG - 2 * RGBMath.min(RGBMath.mult(srcG, destA), RGBMath.mult(destG, srcA)) << 8 | srcB + destB - 2 * RGBMath.min(RGBMath.mult(srcB, destA), RGBMath.mult(destB, srcA));
                ++srcPos;
                ++destPos;
            }
        }
    }

    static class Sub
    extends RGBComposite {
        private Sub() {
        }

        @Override
        void rgb(int[] src, int srcPos, int[] dest, int destPos, int length, int alpha) {
            for (int i = 0; i < length; ++i) {
                int srcPx = src[srcPos];
                int destPx = dest[destPos];
                int srcR = alpha == 255 ? (srcPx & 0xFF0000) >>> 16 : RGBMath.mult((srcPx & 0xFF0000) >>> 16, alpha);
                int srcG = alpha == 255 ? (srcPx & 0xFF00) >>> 8 : RGBMath.mult((srcPx & 0xFF00) >>> 8, alpha);
                int srcB = alpha == 255 ? srcPx & 0xFF : RGBMath.mult(srcPx & 0xFF, alpha);
                int destR = (destPx & 0xFF0000) >>> 16;
                int destG = (destPx & 0xFF00) >>> 8;
                int destB = destPx & 0xFF;
                dest[destPos] = RGBMath.max(destR - srcR, 0) << 16 | RGBMath.max(destG - srcG, 0) << 8 | RGBMath.max(destB - srcB, 0);
                ++srcPos;
                ++destPos;
            }
        }

        @Override
        void argb(int[] src, int srcPos, int[] dest, int destPos, int length, int alpha) {
            for (int i = 0; i < length; ++i) {
                int srcPx = src[srcPos];
                int destPx = dest[destPos];
                int srcA = alpha == 255 ? (srcPx & 0xFF000000) >>> 24 : RGBMath.mult((srcPx & 0xFF000000) >>> 24, alpha);
                int srcR = alpha == 255 ? (srcPx & 0xFF0000) >>> 16 : RGBMath.mult((srcPx & 0xFF0000) >>> 16, alpha);
                int srcG = alpha == 255 ? (srcPx & 0xFF00) >>> 8 : RGBMath.mult((srcPx & 0xFF00) >>> 8, alpha);
                int srcB = alpha == 255 ? srcPx & 0xFF : RGBMath.mult(srcPx & 0xFF, alpha);
                int destA = (destPx & 0xFF000000) >>> 24;
                int destR = (destPx & 0xFF0000) >>> 16;
                int destG = (destPx & 0xFF00) >>> 8;
                int destB = destPx & 0xFF;
                dest[destPos] = RGBMath.blend(srcA, destA, srcA) << 24 | RGBMath.max(destR - srcR, 0) << 16 | RGBMath.max(destG - srcG, 0) << 8 | RGBMath.max(destB - srcB, 0);
                ++srcPos;
                ++destPos;
            }
        }
    }

    static class Normal
    extends RGBComposite {
        private Normal() {
        }

        @Override
        void rgb(int[] src, int srcPos, int[] dest, int destPos, int length, int alpha) {
            for (int i = 0; i < length; ++i) {
                int srcPx = src[srcPos];
                int destPx = dest[destPos];
                int srcR = alpha == 255 ? (srcPx & 0xFF0000) >>> 16 : RGBMath.mult((srcPx & 0xFF0000) >>> 16, alpha);
                int srcG = alpha == 255 ? (srcPx & 0xFF00) >>> 8 : RGBMath.mult((srcPx & 0xFF00) >>> 8, alpha);
                int srcB = alpha == 255 ? srcPx & 0xFF : RGBMath.mult(srcPx & 0xFF, alpha);
                int destR = (destPx & 0xFF0000) >>> 16;
                int destG = (destPx & 0xFF00) >>> 8;
                int destB = destPx & 0xFF;
                dest[destPos] = RGBMath.blend(srcR, destR, alpha) << 16 | RGBMath.blend(srcG, destG, alpha) << 8 | RGBMath.blend(srcB, destB, alpha);
                ++srcPos;
                ++destPos;
            }
        }

        @Override
        void argb(int[] src, int srcPos, int[] dest, int destPos, int length, int alpha) {
            for (int i = 0; i < length; ++i) {
                int srcPx = src[srcPos];
                int destPx = dest[destPos];
                int srcA = alpha == 255 ? (srcPx & 0xFF000000) >>> 24 : RGBMath.mult((srcPx & 0xFF000000) >>> 24, alpha);
                int srcR = alpha == 255 ? (srcPx & 0xFF0000) >>> 16 : RGBMath.mult((srcPx & 0xFF0000) >>> 16, alpha);
                int srcG = alpha == 255 ? (srcPx & 0xFF00) >>> 8 : RGBMath.mult((srcPx & 0xFF00) >>> 8, alpha);
                int srcB = alpha == 255 ? srcPx & 0xFF : RGBMath.mult(srcPx & 0xFF, alpha);
                int destA = (destPx & 0xFF000000) >>> 24;
                int destR = (destPx & 0xFF0000) >>> 16;
                int destG = (destPx & 0xFF00) >>> 8;
                int destB = destPx & 0xFF;
                dest[destPos] = RGBMath.blend(srcA, destA, srcA) << 24 | RGBMath.blend(srcR, destR, srcA) << 16 | RGBMath.blend(srcG, destG, srcA) << 8 | RGBMath.blend(srcB, destB, srcA);
                ++srcPos;
                ++destPos;
            }
        }
    }

    static class Add
    extends RGBComposite {
        private Add() {
        }

        @Override
        void rgb(int[] src, int srcPos, int[] dest, int destPos, int length, int alpha) {
            for (int i = 0; i < length; ++i) {
                int srcB;
                int srcG;
                int srcR;
                int srcPx = src[srcPos];
                int destPx = dest[destPos];
                if (alpha == 255) {
                    srcR = (srcPx & 0xFF0000) >>> 16;
                    srcG = (srcPx & 0xFF00) >>> 8;
                    srcB = srcPx & 0xFF;
                } else {
                    srcR = RGBMath.mult((srcPx & 0xFF0000) >>> 16, alpha);
                    srcG = RGBMath.mult((srcPx & 0xFF00) >>> 8, alpha);
                    srcB = RGBMath.mult(srcPx & 0xFF, alpha);
                }
                int destR = (destPx & 0xFF0000) >>> 16;
                int destG = (destPx & 0xFF00) >>> 8;
                int destB = destPx & 0xFF;
                dest[destPos] = RGBMath.min(srcR + destR, 255) << 16 | RGBMath.min(srcG + destG, 255) << 8 | RGBMath.min(srcB + destB, 255);
                ++srcPos;
                ++destPos;
            }
        }

        @Override
        void argb(int[] src, int srcPos, int[] dest, int destPos, int length, int alpha) {
            for (int i = 0; i < length; ++i) {
                int srcPx = src[srcPos];
                int destPx = dest[destPos];
                int srcA = alpha == 255 ? (srcPx & 0xFF000000) >>> 24 : RGBMath.mult((srcPx & 0xFF000000) >>> 24, alpha);
                int srcR = alpha == 255 ? (srcPx & 0xFF0000) >>> 16 : RGBMath.mult((srcPx & 0xFF0000) >>> 16, alpha);
                int srcG = alpha == 255 ? (srcPx & 0xFF00) >>> 8 : RGBMath.mult((srcPx & 0xFF00) >>> 8, alpha);
                int srcB = alpha == 255 ? srcPx & 0xFF : RGBMath.mult(srcPx & 0xFF, alpha);
                int destA = (destPx & 0xFF000000) >>> 24;
                int destR = (destPx & 0xFF0000) >>> 16;
                int destG = (destPx & 0xFF00) >>> 8;
                int destB = destPx & 0xFF;
                int a = RGBMath.min(srcA + destA, 255);
                dest[destPos] = a << 24 | RGBMath.min(srcR + destR, a) << 16 | RGBMath.min(srcG + destG, a) << 8 | RGBMath.min(srcB + destB, a);
                ++srcPos;
                ++destPos;
            }
        }
    }
}

