/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.render.ops;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import org.praxislive.video.render.PixelData;
import org.praxislive.video.render.SurfaceOp;
import org.praxislive.video.render.ops.BlendMode;
import org.praxislive.video.render.ops.Blit;
import org.praxislive.video.render.ops.TempData;
import org.praxislive.video.render.utils.ImageUtils;

public class TransformBlit
implements SurfaceOp {
    private static final Logger LOG = Logger.getLogger(TransformBlit.class.getName());
    private final Rectangle srcRegion = new Rectangle();
    private final Rectangle dstRegion = new Rectangle();
    private final AffineTransform transform = new AffineTransform();
    private boolean hasSrcRegion;
    private boolean hasDstRegion;
    private BlendMode blendMode = BlendMode.Normal;
    private double opacity = 1.0;

    public void setTransform(AffineTransform transform) {
        if (transform == null) {
            this.transform.setToIdentity();
        } else {
            this.transform.setTransform(transform);
        }
    }

    public AffineTransform getTransform(AffineTransform transform) {
        if (transform == null) {
            transform = new AffineTransform(this.transform);
        } else {
            transform.setTransform(this.transform);
        }
        return transform;
    }

    public TransformBlit setSourceRegion(Rectangle rect) {
        if (rect == null) {
            this.hasSrcRegion = false;
        } else {
            this.hasSrcRegion = true;
            this.srcRegion.setBounds(rect);
        }
        return this;
    }

    public TransformBlit setSourceRegion(int x, int y, int width, int height) {
        this.hasSrcRegion = true;
        this.srcRegion.setBounds(x, y, width, height);
        return this;
    }

    public Rectangle getSourceRegion(Rectangle rect) {
        if (this.hasSrcRegion) {
            if (rect == null) {
                rect = new Rectangle(this.srcRegion);
            } else {
                rect.setBounds(this.srcRegion);
            }
            return rect;
        }
        return null;
    }

    public boolean hasSourceRegion() {
        return this.hasSrcRegion;
    }

    public TransformBlit setDestinationRegion(Rectangle rect) {
        if (rect == null) {
            this.hasDstRegion = false;
        } else {
            this.hasDstRegion = true;
            this.dstRegion.setBounds(rect);
        }
        return this;
    }

    public TransformBlit setDestinationRegion(int x, int y, int width, int height) {
        this.hasDstRegion = true;
        this.dstRegion.setBounds(x, y, width, height);
        return this;
    }

    public Rectangle getDestinationRegion(Rectangle rect) {
        if (this.hasDstRegion) {
            if (rect == null) {
                rect = new Rectangle(this.dstRegion);
            } else {
                rect.setBounds(this.dstRegion);
            }
            return rect;
        }
        return null;
    }

    public boolean hasDestinationRegion() {
        return this.hasDstRegion;
    }

    public TransformBlit setBlendMode(BlendMode blendMode) {
        if (blendMode == null) {
            throw new NullPointerException();
        }
        this.blendMode = blendMode;
        return this;
    }

    public BlendMode getBlendMode() {
        return this.blendMode;
    }

    public TransformBlit setOpacity(double opacity) {
        if (opacity < 0.0 || opacity > 1.0) {
            throw new IllegalArgumentException();
        }
        this.opacity = opacity;
        return this;
    }

    public double getOpacity() {
        return this.opacity;
    }

    @Override
    public void process(PixelData output, PixelData ... inputs) {
        if (inputs.length < 1) {
            return;
        }
        AlphaComposite cmp = this.compositeFromBlend();
        if (cmp != null) {
            this.processDirect(cmp, output, inputs[0]);
        } else {
            this.processIndirect(output, inputs[0]);
        }
    }

    private void processDirect(AlphaComposite cmp, PixelData output, PixelData input) {
        LOG.fine("Processing TransformBlit direct");
        BufferedImage out = ImageUtils.toImage(output);
        BufferedImage in = ImageUtils.toImage(input);
        Graphics2D g2d = out.createGraphics();
        g2d.setComposite(cmp);
        g2d.setTransform(this.transform);
        int sx1 = this.hasSrcRegion ? this.srcRegion.x : 0;
        int sy1 = this.hasSrcRegion ? this.srcRegion.y : 0;
        int sx2 = this.hasSrcRegion ? sx1 + this.srcRegion.width : in.getWidth();
        int sy2 = this.hasSrcRegion ? sy1 + this.srcRegion.height : in.getHeight();
        int dx1 = this.hasDstRegion ? this.dstRegion.x : 0;
        int dy1 = this.hasDstRegion ? this.dstRegion.y : 0;
        int dx2 = this.hasDstRegion ? dx1 + this.dstRegion.width : out.getWidth();
        int dy2 = this.hasDstRegion ? dy1 + this.dstRegion.height : out.getHeight();
        g2d.drawImage(in, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
    }

    private AlphaComposite compositeFromBlend() {
        if (this.blendMode == BlendMode.Normal) {
            return AlphaComposite.SrcOver.derive((float)this.opacity);
        }
        return null;
    }

    private void processIndirect(PixelData output, PixelData input) {
        int sy2;
        int sx1 = this.hasSrcRegion ? this.srcRegion.x : 0;
        int sy1 = this.hasSrcRegion ? this.srcRegion.y : 0;
        int sx2 = this.hasSrcRegion ? sx1 + this.srcRegion.width : input.getWidth();
        int n = sy2 = this.hasSrcRegion ? sy1 + this.srcRegion.height : input.getHeight();
        if (!this.hasDstRegion) {
            this.dstRegion.setBounds(0, 0, output.getWidth(), output.getHeight());
        }
        Rectangle bounds = this.transform.createTransformedShape(this.dstRegion).getBounds();
        bounds = bounds.intersection(new Rectangle(0, 0, output.getWidth(), output.getHeight()));
        LOG.fine("Calculated bounds\n" + bounds);
        TempData tmp = TempData.create(bounds.width, bounds.height, true);
        BufferedImage tmpIm = ImageUtils.toImage(tmp);
        BufferedImage in = ImageUtils.toImage(input);
        Graphics2D g2d = tmpIm.createGraphics();
        g2d.setComposite(AlphaComposite.Src);
        g2d.translate(-bounds.x, -bounds.y);
        g2d.transform(this.transform);
        g2d.drawImage(in, this.dstRegion.x, this.dstRegion.y, this.dstRegion.x + this.dstRegion.width, this.dstRegion.y + this.dstRegion.height, sx1, sy1, sx2, sy2, null);
        new Blit().setX(bounds.x).setY(bounds.y).setBlendMode(this.blendMode).setOpacity(this.opacity).process(output, tmp);
        tmp.release();
    }
}

