/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.utils;

import java.awt.Dimension;
import java.awt.Rectangle;
import org.praxislive.video.utils.ResizeMode;

public class ResizeUtils {
    private ResizeUtils() {
    }

    public static void calculateBounds(Dimension src, Dimension dest, ResizeMode mode, Rectangle srcBounds, Rectangle destBounds) {
        switch (mode.getType()) {
            case Crop: {
                ResizeUtils.calculateCrop(src, dest, mode, srcBounds, destBounds);
                break;
            }
            case Scale: {
                ResizeUtils.calculateScale(src, dest, mode, srcBounds, destBounds);
                break;
            }
            case Stretch: {
                ResizeUtils.calculateStretch(src, dest, mode, srcBounds, destBounds);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static void calculateCrop(Dimension src, Dimension dest, ResizeMode mode, Rectangle srcBounds, Rectangle destBounds) {
        double vAlign;
        double hAlign;
        int diff = src.width - dest.width;
        if (diff == 0) {
            srcBounds.x = 0;
            destBounds.x = 0;
            srcBounds.width = src.width;
            destBounds.width = dest.width;
        } else if (diff > 0) {
            hAlign = mode.getHorizontalAlignment();
            srcBounds.x = (int)Math.round((double)diff * hAlign);
            srcBounds.width = dest.width;
            destBounds.x = 0;
            destBounds.width = dest.width;
        } else {
            hAlign = mode.getHorizontalAlignment();
            destBounds.x = -((int)Math.round((double)diff * hAlign));
            destBounds.width = src.width;
            srcBounds.x = 0;
            srcBounds.width = src.width;
        }
        diff = src.height - dest.height;
        if (diff == 0) {
            srcBounds.y = 0;
            destBounds.y = 0;
            srcBounds.height = src.height;
            destBounds.height = dest.height;
        } else if (diff > 0) {
            vAlign = mode.getVerticalAlignment();
            srcBounds.y = (int)Math.round((double)diff * vAlign);
            srcBounds.height = dest.height;
            destBounds.y = 0;
            destBounds.height = dest.height;
        } else {
            vAlign = mode.getVerticalAlignment();
            destBounds.y = -((int)Math.round((double)diff * vAlign));
            destBounds.height = src.height;
            srcBounds.y = 0;
            srcBounds.height = src.height;
        }
    }

    private static void calculateScale(Dimension src, Dimension dest, ResizeMode mode, Rectangle srcBounds, Rectangle destBounds) {
        srcBounds.x = 0;
        srcBounds.y = 0;
        srcBounds.width = src.width;
        srcBounds.height = src.height;
        double ratio = Math.min((double)dest.width / (double)src.width, (double)dest.height / (double)src.height);
        destBounds.width = (int)Math.round(ratio * (double)src.width);
        destBounds.height = (int)Math.round(ratio * (double)src.height);
        int diff = dest.width - destBounds.width;
        destBounds.x = diff > 0 ? (int)Math.round(mode.getHorizontalAlignment() * (double)diff) : 0;
        diff = dest.height - destBounds.height;
        destBounds.y = diff > 0 ? (int)Math.round(mode.getVerticalAlignment() * (double)diff) : 0;
    }

    private static void calculateScaleHeight(Dimension src, Dimension dest, ResizeMode mode, Rectangle srcBounds, Rectangle destBounds) {
        double ratio = (double)dest.height / (double)src.height;
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private static void calculateScaleWidth(Dimension src, Dimension dest, ResizeMode mode, Rectangle srcBounds, Rectangle destBounds) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private static void calculateStretch(Dimension src, Dimension dest, ResizeMode mode, Rectangle srcBounds, Rectangle destBounds) {
        srcBounds.x = 0;
        srcBounds.y = 0;
        srcBounds.width = src.width;
        srcBounds.height = src.height;
        destBounds.x = 0;
        destBounds.y = 0;
        destBounds.width = dest.width;
        destBounds.height = dest.height;
    }
}

