/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.render.ops;

import java.awt.Rectangle;
import org.praxislive.video.render.PixelData;
import org.praxislive.video.render.SurfaceOp;
import org.praxislive.video.render.ops.BlendMode;
import org.praxislive.video.render.ops.BlendUtil;
import org.praxislive.video.render.ops.SubPixels;

public final class Blit
implements SurfaceOp {
    private final Rectangle srcRegion = new Rectangle();
    private BlendMode blendMode = BlendMode.Normal;
    private double opacity = 1.0;
    private int x = 0;
    private int y = 0;
    private boolean hasRegion = false;

    public Blit setX(int x) {
        this.x = x;
        return this;
    }

    public int getX() {
        return this.x;
    }

    public Blit setY(int y) {
        this.y = y;
        return this;
    }

    public int getY() {
        return this.y;
    }

    public Blit setSourceRegion(Rectangle rect) {
        if (rect == null) {
            this.hasRegion = false;
        } else {
            this.hasRegion = true;
            this.srcRegion.setBounds(rect);
        }
        return this;
    }

    public Blit setSourceRegion(int x, int y, int width, int height) {
        this.hasRegion = true;
        this.srcRegion.setBounds(x, y, width, height);
        return this;
    }

    public Rectangle getSourceRegion(Rectangle rect) {
        if (this.hasRegion) {
            if (rect == null) {
                rect = new Rectangle(this.srcRegion);
            } else {
                rect.setBounds(this.srcRegion);
            }
            return rect;
        }
        return null;
    }

    public boolean hasSourceRegion() {
        return this.hasRegion;
    }

    public Blit setBlendMode(BlendMode blendMode) {
        if (blendMode == null) {
            throw new NullPointerException();
        }
        this.blendMode = blendMode;
        return this;
    }

    public BlendMode getBlendMode() {
        return this.blendMode;
    }

    public Blit setOpacity(double opacity) {
        if (opacity < 0.0 || opacity > 1.0) {
            throw new IllegalArgumentException();
        }
        this.opacity = opacity;
        return this;
    }

    public double getOpacity() {
        return this.opacity;
    }

    @Override
    public void process(PixelData output, PixelData ... inputs) {
        if (inputs.length < 1) {
            return;
        }
        if (!this.hasRegion && this.x == 0 && this.y == 0) {
            BlendUtil.process(inputs[0], output, this.blendMode, this.opacity);
        } else {
            this.processComplex(inputs[0], output);
        }
    }

    private void processComplex(PixelData src, PixelData dst) {
        Rectangle sRct = new Rectangle(0, 0, src.getWidth(), src.getHeight());
        int srcX = 0;
        int srcY = 0;
        if (this.hasRegion) {
            if ((sRct = sRct.intersection(this.srcRegion)).isEmpty()) {
                return;
            }
            srcX = sRct.x;
            srcY = sRct.y;
        }
        Rectangle dRct = new Rectangle(0, 0, dst.getWidth(), dst.getHeight());
        sRct.translate(this.x - srcX, this.y - srcY);
        Rectangle intersection = dRct.intersection(sRct);
        if (intersection.isEmpty()) {
            return;
        }
        sRct.setBounds(intersection);
        dRct.setBounds(intersection);
        sRct.translate(srcX - this.x, srcY - this.y);
        SubPixels srcPD = SubPixels.create(src, sRct.x, sRct.y, sRct.width, sRct.height);
        SubPixels dstPD = SubPixels.create(dst, dRct.x, dRct.y, dRct.width, dRct.height);
        BlendUtil.process(srcPD, dstPD, this.blendMode, this.opacity);
    }

    @Deprecated
    public static SurfaceOp op() {
        return new Blit();
    }
}

