/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.render.ops;

import org.praxislive.video.render.PixelData;
import org.praxislive.video.render.SurfaceOp;
import org.praxislive.video.render.ops.TempData;
import org.praxislive.video.render.utils.PixelArrayCache;

public class Blur
implements SurfaceOp {
    private int xRadius;
    private int yRadius;
    private TempData tmp;

    private Blur(int radius) {
        this.xRadius = radius;
        this.yRadius = radius;
    }

    @Override
    public void process(PixelData output, PixelData ... inputs) {
        int dstH = output.getWidth();
        int dstW = output.getHeight();
        if (this.tmp == null || this.tmp.getWidth() != dstW || this.tmp.getHeight() != dstH) {
            this.tmp = TempData.create(dstW, dstH, true);
        }
        this.blur(output, this.tmp, this.xRadius);
        this.blur(this.tmp, output, this.yRadius);
        this.tmp.release();
    }

    private void blur(PixelData src, PixelData dst, int radius) {
        int i;
        int windowSize = radius * 2 + 1;
        int radiusPlusOne = radius + 1;
        int srcIndex = src.getOffset();
        int srcSL = src.getScanline();
        int dstSL = dst.getScanline();
        int lookupSize = 256 * windowSize;
        int[] sumLookupTable = PixelArrayCache.acquire(lookupSize, false);
        for (int i2 = 0; i2 < lookupSize; ++i2) {
            sumLookupTable[i2] = i2 / windowSize;
        }
        int[] indexLookupTable = new int[radiusPlusOne];
        int width = src.getWidth();
        if (radius < width) {
            for (i = 0; i < indexLookupTable.length; ++i) {
                indexLookupTable[i] = i;
            }
        } else {
            for (i = 0; i < width; ++i) {
                indexLookupTable[i] = i;
            }
            for (i = width; i < indexLookupTable.length; ++i) {
                indexLookupTable[i] = width - 1;
            }
        }
        int height = src.getHeight();
        int[] srcPixels = src.getData();
        int[] dstPixels = dst.getData();
        for (int y = 0; y < height; ++y) {
            int sumBlue = 0;
            int sumGreen = 0;
            int sumRed = 0;
            int sumAlpha = 0;
            int dstIndex = y + dst.getOffset();
            int pixel = srcPixels[srcIndex];
            sumAlpha += radiusPlusOne * (pixel >> 24 & 0xFF);
            sumRed += radiusPlusOne * (pixel >> 16 & 0xFF);
            sumGreen += radiusPlusOne * (pixel >> 8 & 0xFF);
            sumBlue += radiusPlusOne * (pixel & 0xFF);
            for (int i3 = 1; i3 <= radius; ++i3) {
                pixel = srcPixels[srcIndex + indexLookupTable[i3]];
                sumAlpha += pixel >> 24 & 0xFF;
                sumRed += pixel >> 16 & 0xFF;
                sumGreen += pixel >> 8 & 0xFF;
                sumBlue += pixel & 0xFF;
            }
            for (int x = 0; x < width; ++x) {
                int previousPixelIndex;
                dstPixels[dstIndex] = sumLookupTable[sumAlpha] << 24 | sumLookupTable[sumRed] << 16 | sumLookupTable[sumGreen] << 8 | sumLookupTable[sumBlue];
                dstIndex += dstSL;
                int nextPixelIndex = x + radiusPlusOne;
                if (nextPixelIndex >= width) {
                    nextPixelIndex = width - 1;
                }
                if ((previousPixelIndex = x - radius) < 0) {
                    previousPixelIndex = 0;
                }
                int nextPixel = srcPixels[srcIndex + nextPixelIndex];
                int previousPixel = srcPixels[srcIndex + previousPixelIndex];
                sumAlpha += nextPixel >> 24 & 0xFF;
                sumAlpha -= previousPixel >> 24 & 0xFF;
                sumRed += nextPixel >> 16 & 0xFF;
                sumRed -= previousPixel >> 16 & 0xFF;
                sumGreen += nextPixel >> 8 & 0xFF;
                sumGreen -= previousPixel >> 8 & 0xFF;
                sumBlue += nextPixel & 0xFF;
                sumBlue -= previousPixel & 0xFF;
            }
            srcIndex += srcSL;
        }
        PixelArrayCache.release(sumLookupTable);
    }

    public static SurfaceOp op(int radius) {
        if (radius < 0) {
            throw new IllegalArgumentException();
        }
        return new Blur(radius);
    }
}

