/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video;

import java.util.Objects;
import org.praxislive.core.Clock;
import org.praxislive.core.Lookup;

public final class PlayerConfiguration {
    private final Clock clock;
    private final int width;
    private final int height;
    private final double fps;
    private final Lookup lookup;

    public PlayerConfiguration(Clock clock, int width, int height, double fps) {
        this(clock, width, height, fps, Lookup.EMPTY);
    }

    public PlayerConfiguration(Clock clock, int width, int height, double fps, Lookup lookup) {
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("Illegal dimensions");
        }
        if (lookup == null) {
            throw new NullPointerException();
        }
        this.clock = Objects.requireNonNull(clock);
        this.width = width;
        this.height = height;
        this.fps = fps;
        this.lookup = lookup;
    }

    public Clock getClock() {
        return this.clock;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public double getFPS() {
        return this.fps;
    }

    public Lookup getLookup() {
        return this.lookup;
    }
}

