/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.render.ops;

import org.praxislive.video.render.PixelData;
import org.praxislive.video.render.SurfaceOp;
import org.praxislive.video.render.utils.RGBMath;

public class DifferenceOp
implements SurfaceOp {
    private double threshold = 0.0;
    private Mode mode = Mode.Color;

    @Override
    public void process(PixelData output, PixelData ... inputs) {
        if (inputs.length < 1) {
            return;
        }
        switch (this.mode.ordinal()) {
            case 0: {
                this.processColor(output, inputs[0]);
                break;
            }
            case 1: {
                this.processMono(output, inputs[0]);
                break;
            }
            case 2: {
                this.processThreshold(output, inputs[0]);
            }
        }
    }

    public void setThreshold(double threshold) {
        if (threshold < 0.0 || threshold > 1.0) {
            throw new IllegalArgumentException();
        }
        this.threshold = threshold;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setMode(Mode mode) {
        if (mode == null) {
            throw new NullPointerException();
        }
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    private void processColor(PixelData output, PixelData input) {
        int thres = (int)Math.round(this.threshold * 256.0);
        int width = Math.min(input.getWidth(), output.getWidth());
        int height = Math.min(input.getHeight(), output.getHeight());
        int bgDelta = input.getScanline() - width;
        int fgDelta = output.getScanline() - width;
        int[] bgData = input.getData();
        int[] fgData = output.getData();
        int bgIdx = 0;
        int fgIdx = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int fg = fgData[fgIdx];
                int fgR = (fg & 0xFF0000) >>> 16;
                int fgG = (fg & 0xFF00) >>> 8;
                int fgB = fg & 0xFF;
                int bg = bgData[bgIdx];
                int bgR = (bg & 0xFF0000) >>> 16;
                int bgG = (bg & 0xFF00) >>> 8;
                int bgB = bg & 0xFF;
                int maxDelta = RGBMath.max(fgR = RGBMath.diff(fgR, bgR), fgG = RGBMath.diff(fgG, bgG), fgB = RGBMath.diff(fgB, bgB));
                fgData[fgIdx] = maxDelta < thres ? 0 : fg & 0xFF000000 | fgR << 16 | fgG << 8 | fgB;
                ++bgIdx;
                ++fgIdx;
            }
            bgIdx += bgDelta;
            fgIdx += fgDelta;
        }
    }

    private void processMono(PixelData output, PixelData input) {
        int thres = (int)Math.round(this.threshold * 256.0);
        int width = Math.min(input.getWidth(), output.getWidth());
        int height = Math.min(input.getHeight(), output.getHeight());
        int bgDelta = input.getScanline() - width;
        int fgDelta = output.getScanline() - width;
        int[] bgData = input.getData();
        int[] fgData = output.getData();
        int bgIdx = 0;
        int fgIdx = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int fg = fgData[fgIdx];
                int fgR = (fg & 0xFF0000) >>> 16;
                int fgG = (fg & 0xFF00) >>> 8;
                int fgB = fg & 0xFF;
                int bg = bgData[bgIdx];
                int bgR = (bg & 0xFF0000) >>> 16;
                int bgG = (bg & 0xFF00) >>> 8;
                int bgB = bg & 0xFF;
                int maxDelta = RGBMath.max(fgR = RGBMath.diff(fgR, bgR), fgG = RGBMath.diff(fgG, bgG), fgB = RGBMath.diff(fgB, bgB));
                fgData[fgIdx] = maxDelta < thres ? 0 : fg & 0xFF000000 | maxDelta << 16 | maxDelta << 8 | maxDelta;
                ++bgIdx;
                ++fgIdx;
            }
            bgIdx += bgDelta;
            fgIdx += fgDelta;
        }
    }

    private void processThreshold(PixelData output, PixelData input) {
        int thres = (int)Math.round(this.threshold * 256.0);
        int width = Math.min(input.getWidth(), output.getWidth());
        int height = Math.min(input.getHeight(), output.getHeight());
        int bgDelta = input.getScanline() - width;
        int fgDelta = output.getScanline() - width;
        int[] bgData = input.getData();
        int[] fgData = output.getData();
        int bgIdx = 0;
        int fgIdx = 0;
        boolean alpha = output.hasAlpha();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int fg = fgData[fgIdx];
                int fgR = (fg & 0xFF0000) >>> 16;
                int fgG = (fg & 0xFF00) >>> 8;
                int fgB = fg & 0xFF;
                int bg = bgData[bgIdx];
                int bgR = (bg & 0xFF0000) >>> 16;
                int bgG = (bg & 0xFF00) >>> 8;
                int bgB = bg & 0xFF;
                int maxDelta = RGBMath.max(fgR = RGBMath.diff(fgR, bgR), fgG = RGBMath.diff(fgG, bgG), fgB = RGBMath.diff(fgB, bgB));
                fgData[fgIdx] = maxDelta < thres ? 0 : (alpha ? -1 : 0xFFFFFF);
                ++bgIdx;
                ++fgIdx;
            }
            bgIdx += bgDelta;
            fgIdx += fgDelta;
        }
    }

    public static enum Mode {
        Color,
        Mono,
        Threshold;

    }
}

