/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.render.utils;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.praxislive.video.render.PixelData;
import org.praxislive.video.render.Surface;
import org.praxislive.video.render.SurfaceOp;
import org.praxislive.video.render.ops.Blit;
import org.praxislive.video.render.ops.GraphicsOp;
import org.praxislive.video.render.ops.Reverse;

public class BufferedImageSurface
extends Surface {
    private static final Logger LOG = Logger.getLogger(BufferedImageSurface.class.getName());
    private static final PixelData[] EMPTY_INPUTS = new PixelData[0];
    private static final Image[] EMPTY_IMAGES = new Image[0];
    private BufferedImage image;
    private PixelWrapper pixelData;
    private boolean clear = true;
    private int modCount;

    public BufferedImageSurface(int width, int height, boolean alpha) {
        super(width, height, alpha);
        this.image = alpha ? new BufferedImage(width, height, 3) : new BufferedImage(width, height, 1);
    }

    private BufferedImageSurface(BufferedImage image, boolean alpha) {
        super(image.getWidth(), image.getHeight(), alpha);
        this.image = image;
    }

    @Override
    public Surface createSurface(int width, int height, boolean alpha) {
        return new BufferedImageSurface(width, height, alpha);
    }

    @Override
    public void release() {
    }

    protected BufferedImage getImage() {
        return this.image;
    }

    private PixelData getPixelData() {
        if (this.pixelData == null) {
            int[] data = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
            this.pixelData = new PixelWrapper(this, data, this.getWidth(), this.getHeight(), this.hasAlpha());
        }
        return this.pixelData;
    }

    @Override
    public boolean checkCompatible(Surface surface, boolean checkDimensions, boolean checkAlpha) {
        if (!(surface instanceof BufferedImageSurface)) {
            return false;
        }
        if (checkDimensions && (surface.getWidth() != this.getWidth() || surface.getHeight() != this.getHeight())) {
            return false;
        }
        return !checkAlpha || surface.hasAlpha() == this.hasAlpha();
    }

    @Override
    public void clear() {
        ++this.modCount;
        Graphics2D g = this.image.createGraphics();
        g.setComposite(AlphaComposite.Clear);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.dispose();
        this.clear = true;
    }

    @Override
    public boolean isClear() {
        return this.clear;
    }

    @Override
    public void copy(Surface source) {
        ++this.modCount;
        this.clear = false;
        if (source.hasAlpha() || source.getWidth() < this.getWidth() || source.getHeight() < this.getHeight()) {
            this.clear();
        }
        this.processImpl((SurfaceOp)new Blit(), source);
    }

    @Override
    public void process(SurfaceOp op, Surface ... inputs) {
        ++this.modCount;
        switch (inputs.length) {
            case 0: {
                this.processImpl(op);
                break;
            }
            case 1: {
                this.processImpl(op, inputs[0]);
                break;
            }
            default: {
                this.processImpl(op, inputs);
            }
        }
        this.clear = false;
    }

    private void processImpl(SurfaceOp op) {
        if (op instanceof GraphicsOp) {
            this.processGraphicsOp((GraphicsOp)op, EMPTY_IMAGES);
        } else {
            op.process(this.getPixelData(), EMPTY_INPUTS);
        }
    }

    private void processImpl(SurfaceOp op, Surface input) {
        if (input instanceof BufferedImageSurface) {
            if (op instanceof GraphicsOp) {
                this.processGraphicsOp((GraphicsOp)op, new Image[]{((BufferedImageSurface)input).getImage()});
            } else {
                op.process(this.getPixelData(), ((BufferedImageSurface)input).getPixelData());
            }
        } else {
            SurfaceOp rev = Reverse.op(op, this.getPixelData());
            input.process(rev);
        }
    }

    private void processImpl(SurfaceOp op, Surface[] inputs) {
        if (op instanceof GraphicsOp) {
            this.processGraphicsOp((GraphicsOp)op, this.createImageArray(inputs));
        } else {
            PixelData[] pixelInputs = new PixelData[inputs.length];
            for (int i = 0; i < inputs.length; ++i) {
                if (!(inputs[i] instanceof BufferedImageSurface)) {
                    throw new UnsupportedOperationException("not yet implemented");
                }
                pixelInputs[i] = ((BufferedImageSurface)inputs[i]).getPixelData();
            }
            op.process(this.pixelData, pixelInputs);
        }
    }

    private Image[] createImageArray(Surface[] inputs) {
        if (inputs.length == 0) {
            return EMPTY_IMAGES;
        }
        Image[] ret = new Image[inputs.length];
        for (int i = 0; i < ret.length; ++i) {
            Surface s = inputs[i];
            if (!(s instanceof BufferedImageSurface)) {
                throw new UnsupportedOperationException("not yet implemented");
            }
            ret[i] = ((BufferedImageSurface)s).getImage();
        }
        return ret;
    }

    private void processGraphicsOp(GraphicsOp op, Image[] images) {
        Graphics2D g = this.getImage().createGraphics();
        op.getCallback().draw(g, images);
    }

    public void save(String type, File file) throws IOException {
        boolean success = ImageIO.write((RenderedImage)this.image, type, file);
        if (!success) {
            throw new IOException("Can't find writer for supplied type : " + type);
        }
    }

    @Override
    public int getModCount() {
        return this.modCount;
    }

    public static BufferedImageSurface load(URI location) throws IOException {
        BufferedImage im = ImageIO.read(location.toURL());
        if (im == null) {
            throw new IOException();
        }
        if (im.getType() == 1) {
            return new BufferedImageSurface(im, false);
        }
        if (im.getType() == 3) {
            return new BufferedImageSurface(im, true);
        }
        if (im.getTransparency() == 1) {
            BufferedImage im2 = new BufferedImage(im.getWidth(), im.getHeight(), 1);
            im2.createGraphics().drawImage((Image)im, 0, 0, null);
            return new BufferedImageSurface(im2, false);
        }
        BufferedImage im2 = new BufferedImage(im.getWidth(), im.getHeight(), 3);
        im2.createGraphics().drawImage((Image)im, 0, 0, null);
        return new BufferedImageSurface(im2, true);
    }

    private class PixelWrapper
    implements PixelData {
        private int[] data;
        private int width;
        private int height;
        private boolean alpha;

        private PixelWrapper(BufferedImageSurface bufferedImageSurface, int[] data, int width, int height, boolean alpha) {
            this.data = data;
            this.width = width;
            this.height = height;
            this.alpha = alpha;
        }

        @Override
        public int[] getData() {
            return this.data;
        }

        @Override
        public int getOffset() {
            return 0;
        }

        @Override
        public int getScanline() {
            return this.width;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public boolean hasAlpha() {
            return this.alpha;
        }
    }
}

