/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.render.utils;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.praxislive.video.render.PixelData;

public class ImageUtils {
    private static final ImageUtils instance = new ImageUtils();
    private static final DirectColorModel rgbCM = new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
    private static final DirectColorModel pre_argbCM = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, 3);

    private ImageUtils() {
    }

    public static BufferedImage toImage(PixelData pd) {
        int w = pd.getWidth();
        int h = pd.getHeight();
        int offset = pd.getOffset();
        int sl = pd.getScanline();
        DataBufferInt db = new DataBufferInt(pd.getData(), sl * h, offset);
        DirectColorModel cm = ImageUtils.getColorModel(pd.hasAlpha());
        WritableRaster raster = Raster.createPackedRaster(db, w, h, sl, cm.getMasks(), null);
        return new BufferedImage(cm, raster, pd.hasAlpha(), null);
    }

    private static DirectColorModel getColorModel(boolean alpha) {
        if (alpha) {
            return pre_argbCM;
        }
        return rgbCM;
    }
}

