/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.render.ops;

import org.praxislive.video.render.PixelData;
import org.praxislive.video.render.utils.PixelArrayCache;

class TempData
implements PixelData {
    private int[] data;
    private int width;
    private int height;
    private boolean alpha;

    TempData() {
    }

    @Override
    public int[] getData() {
        if (this.data == null) {
            this.data = PixelArrayCache.acquire(this.width * this.height, true);
        }
        return this.data;
    }

    @Override
    public int getOffset() {
        return 0;
    }

    @Override
    public int getScanline() {
        return this.width;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean hasAlpha() {
        return this.alpha;
    }

    void release() {
        PixelArrayCache.release(this.data);
        this.data = null;
    }

    static TempData create(int width, int height, boolean alpha) {
        TempData tmp = new TempData();
        tmp.width = width;
        tmp.height = height;
        tmp.alpha = alpha;
        return tmp;
    }
}

