/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.utils;

public final class ResizeMode {
    private Type type;
    private double horizontalAlignment;
    private double verticalAlignment;

    public ResizeMode(Type type, double hAlign, double vAlign) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (hAlign < 0.0 || hAlign > 1.0 || vAlign < 0.0 || vAlign > 1.0) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        this.horizontalAlignment = hAlign;
        this.verticalAlignment = vAlign;
    }

    public Type getType() {
        return this.type;
    }

    public double getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public double getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResizeMode) {
            ResizeMode o = (ResizeMode)obj;
            return o.type == this.type && o.horizontalAlignment == this.horizontalAlignment && o.verticalAlignment == this.verticalAlignment;
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.horizontalAlignment) ^ Double.doubleToLongBits(this.horizontalAlignment) >>> 32);
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.verticalAlignment) ^ Double.doubleToLongBits(this.verticalAlignment) >>> 32);
        return hash;
    }

    public static enum Type {
        Crop,
        Stretch,
        Scale;

    }
}

