/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.pipes.impl;

import org.praxislive.video.pipes.SinkIsFullException;
import org.praxislive.video.pipes.VideoPipe;
import org.praxislive.video.pipes.impl.SingleOut;
import org.praxislive.video.render.Surface;

public abstract class SingleInOut
extends SingleOut {
    private VideoPipe source;
    private long renderReqTime;
    private boolean renderReqCache;

    @Override
    public final void registerSource(VideoPipe source) {
        if (source == null) {
            throw new NullPointerException();
        }
        if (this.source != null) {
            throw new SinkIsFullException();
        }
        this.source = source;
    }

    @Override
    public final void unregisterSource(VideoPipe source) {
        if (this.source == source) {
            this.source = null;
        }
    }

    @Override
    public final VideoPipe getSource(int idx) {
        if (idx == 0 && this.source != null) {
            return this.source;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int getSourceCount() {
        return this.source == null ? 0 : 1;
    }

    @Override
    public final int getSourceCapacity() {
        return 1;
    }

    @Override
    protected boolean isRenderRequired(VideoPipe source, long time) {
        return this.isRendering(time);
    }

    boolean isRendering(long time) {
        if (time != this.renderReqTime) {
            this.renderReqTime = time;
            this.renderReqCache = this.sink == null ? false : this.sinkRequiresRender(this.sink, time);
        }
        return this.renderReqCache;
    }

    @Override
    void processImpl(VideoPipe sink, Surface surface, long time) {
        if (this.sink == sink) {
            if (this.source == null) {
                surface.clear();
            } else {
                this.callSource(this.source, surface, time);
            }
            this.process(surface, this.isRendering(time));
        }
    }
}

