/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.render;

import org.praxislive.video.render.SurfaceOp;

public abstract class Surface {
    private static final Surface[] EMPTY = new Surface[0];
    protected final int width;
    protected final int height;
    protected final boolean alpha;
    private final Surface[] holder;

    public Surface(int width, int height, boolean alpha) {
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException();
        }
        this.width = width;
        this.height = height;
        this.alpha = alpha;
        this.holder = new Surface[1];
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final boolean hasAlpha() {
        return this.alpha;
    }

    public void process(SurfaceOp op) {
        this.process(op, EMPTY);
    }

    public void process(SurfaceOp op, Surface input) {
        this.holder[0] = input;
        this.process(op, this.holder);
        this.holder[0] = null;
    }

    public abstract int getModCount();

    public abstract void process(SurfaceOp var1, Surface ... var2);

    public abstract void clear();

    public abstract boolean isClear();

    public abstract void release();

    public abstract void copy(Surface var1);

    public abstract boolean checkCompatible(Surface var1, boolean var2, boolean var3);

    public abstract Surface createSurface(int var1, int var2, boolean var3);

    public Surface createSurface() {
        return this.createSurface(this.width, this.height, this.alpha);
    }
}

