/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.render.ops;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.praxislive.video.render.PixelData;
import org.praxislive.video.render.SurfaceOp;
import org.praxislive.video.render.ops.BlendMode;
import org.praxislive.video.render.ops.Blit;
import org.praxislive.video.render.ops.TempData;
import org.praxislive.video.render.utils.ImageUtils;

public class ScaledBlit
implements SurfaceOp {
    private final Rectangle srcRegion = new Rectangle();
    private final Rectangle dstRegion = new Rectangle();
    private boolean hasSrcRegion;
    private boolean hasDstRegion;
    private BlendMode blendMode = BlendMode.Normal;
    private double opacity = 1.0;

    public ScaledBlit setSourceRegion(Rectangle rect) {
        if (rect == null) {
            this.hasSrcRegion = false;
        } else {
            this.hasSrcRegion = true;
            this.srcRegion.setBounds(rect);
        }
        return this;
    }

    public ScaledBlit setSourceRegion(int x, int y, int width, int height) {
        this.hasSrcRegion = true;
        this.srcRegion.setBounds(x, y, width, height);
        return this;
    }

    public Rectangle getSourceRegion(Rectangle rect) {
        if (this.hasSrcRegion) {
            if (rect == null) {
                rect = new Rectangle(this.srcRegion);
            } else {
                rect.setBounds(this.srcRegion);
            }
            return rect;
        }
        return null;
    }

    public boolean hasSourceRegion() {
        return this.hasSrcRegion;
    }

    public ScaledBlit setDestinationRegion(Rectangle rect) {
        if (rect == null) {
            this.hasDstRegion = false;
        } else {
            this.hasDstRegion = true;
            this.dstRegion.setBounds(rect);
        }
        return this;
    }

    public ScaledBlit setDestinationRegion(int x, int y, int width, int height) {
        this.hasDstRegion = true;
        this.dstRegion.setBounds(x, y, width, height);
        return this;
    }

    public Rectangle getDestinationRegion(Rectangle rect) {
        if (this.hasDstRegion) {
            if (rect == null) {
                rect = new Rectangle(this.dstRegion);
            } else {
                rect.setBounds(this.dstRegion);
            }
            return rect;
        }
        return null;
    }

    public boolean hasDestinationRegion() {
        return this.hasDstRegion;
    }

    public ScaledBlit setBlendMode(BlendMode blendMode) {
        if (blendMode == null) {
            throw new NullPointerException();
        }
        this.blendMode = blendMode;
        return this;
    }

    public BlendMode getBlendMode() {
        return this.blendMode;
    }

    public ScaledBlit setOpacity(double opacity) {
        if (opacity < 0.0 || opacity > 1.0) {
            throw new IllegalArgumentException();
        }
        this.opacity = opacity;
        return this;
    }

    public double getOpacity() {
        return this.opacity;
    }

    @Override
    public void process(PixelData output, PixelData ... inputs) {
        if (inputs.length < 1) {
            return;
        }
        AlphaComposite cmp = this.compositeFromBlend();
        if (cmp != null) {
            this.processDirect(cmp, output, inputs[0]);
        } else {
            this.processIndirect(output, inputs[0]);
        }
    }

    private void processDirect(AlphaComposite cmp, PixelData output, PixelData input) {
        BufferedImage out = ImageUtils.toImage(output);
        BufferedImage in = ImageUtils.toImage(input);
        Graphics2D g2d = out.createGraphics();
        g2d.setComposite(cmp);
        int sx1 = this.hasSrcRegion ? this.srcRegion.x : 0;
        int sy1 = this.hasSrcRegion ? this.srcRegion.y : 0;
        int sx2 = this.hasSrcRegion ? sx1 + this.srcRegion.width : in.getWidth();
        int sy2 = this.hasSrcRegion ? sy1 + this.srcRegion.height : in.getHeight();
        int dx1 = this.hasDstRegion ? this.dstRegion.x : 0;
        int dy1 = this.hasDstRegion ? this.dstRegion.y : 0;
        int dx2 = this.hasDstRegion ? dx1 + this.dstRegion.width : out.getWidth();
        int dy2 = this.hasDstRegion ? dy1 + this.dstRegion.height : out.getHeight();
        g2d.drawImage(in, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
    }

    private AlphaComposite compositeFromBlend() {
        if (this.blendMode == BlendMode.Normal) {
            return AlphaComposite.SrcOver.derive((float)this.opacity);
        }
        return null;
    }

    private void processIndirect(PixelData output, PixelData input) {
        int dh;
        int sx1 = this.hasSrcRegion ? this.srcRegion.x : 0;
        int sy1 = this.hasSrcRegion ? this.srcRegion.y : 0;
        int sx2 = this.hasSrcRegion ? sx1 + this.srcRegion.width : input.getWidth();
        int sy2 = this.hasSrcRegion ? sy1 + this.srcRegion.height : input.getHeight();
        int dx = this.hasDstRegion ? this.dstRegion.x : 0;
        int dy = this.hasDstRegion ? this.dstRegion.y : 0;
        int dw = this.hasDstRegion ? this.dstRegion.width : output.getWidth();
        int n = dh = this.hasDstRegion ? this.dstRegion.height : output.getHeight();
        if (dw <= 0 || dh <= 0) {
            return;
        }
        TempData tmp = TempData.create(dw, dh, input.hasAlpha());
        BufferedImage tmpIm = ImageUtils.toImage(tmp);
        BufferedImage in = ImageUtils.toImage(input);
        Graphics2D g2d = tmpIm.createGraphics();
        g2d.setComposite(AlphaComposite.Src);
        g2d.drawImage(in, 0, 0, dw, dh, sx1, sy1, sx2, sy2, null);
        new Blit().setX(dx).setY(dy).setBlendMode(this.blendMode).setOpacity(this.opacity).process(output, tmp);
        tmp.release();
    }
}

