/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.render.utils;

public class RGBMath {
    public static final int ALPHA_MASK = -16777216;
    public static final int RED_MASK = 0xFF0000;
    public static final int GREEN_MASK = 65280;
    public static final int BLUE_MASK = 255;
    private static int rngseed = 0;

    private RGBMath() {
    }

    public static int min(int a, int b) {
        return a < b ? a : b;
    }

    public static int min(int a, int b, int c) {
        return RGBMath.min(RGBMath.min(a, b), c);
    }

    public static int mix(int a, int b, int f) {
        return a + ((b - a) * f >> 8);
    }

    public static int mix(int a, int b, int af, int bf) {
        return (a * af >> 8) + ((b - a) * bf >> 8);
    }

    public static int max(int a, int b) {
        return a > b ? a : b;
    }

    public static int max(int a, int b, int c) {
        return RGBMath.max(RGBMath.max(a, b), c);
    }

    public static int diff(int a, int b) {
        return a >= b ? a - b : b - a;
    }

    public static int multRGB(int src, int multiplier) {
        return (src & 0xFF0000) * ++multiplier >> 8 & 0xFF0000 | (src & 0xFF00) * multiplier >> 8 & 0xFF00 | (src & 0xFF) * multiplier >> 8;
    }

    public static int multARGB(int src, int multiplier) {
        return (src >>> 24) * ++multiplier << 16 & 0xFF000000 | (src & 0xFF0000) * multiplier >> 8 & 0xFF0000 | (src & 0xFF00) * multiplier >> 8 & 0xFF00 | (src & 0xFF) * multiplier >> 8;
    }

    public static int blend(int src, int dest, int alpha) {
        return src + ((255 - alpha) * dest >> 8);
    }

    public static int mult(int val, int multiplier) {
        return val * (multiplier + 1) >> 8;
    }

    public static int random() {
        rngseed = rngseed * 1103515245 + 12345;
        return rngseed >> 16 & 0xFF;
    }

    public static int premultiply(int argb) {
        int a = argb >>> 24;
        if (a == 0) {
            return 0;
        }
        if (a == 255) {
            return argb;
        }
        return a << 24 | RGBMath.multRGB(argb, a);
    }
}

