/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video;

import org.praxislive.core.Lookup;

public final class ClientConfiguration {
    private final int sourceCount;
    private final int sinkCount;
    private final Lookup lookup;

    public ClientConfiguration(int sourceCount, int sinkCount) {
        this(sourceCount, sinkCount, Lookup.EMPTY);
    }

    public ClientConfiguration(int sourceCount, int sinkCount, Lookup lookup) {
        if (sourceCount < 0) {
            throw new IllegalArgumentException();
        }
        if (sinkCount < 0) {
            throw new IllegalArgumentException();
        }
        this.sourceCount = sourceCount;
        this.sinkCount = sinkCount;
        this.lookup = lookup;
    }

    public int getSourceCount() {
        return this.sourceCount;
    }

    public int getSinkCount() {
        return this.sinkCount;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public static final class DeviceIndex {
        private final int index;

        public DeviceIndex(int index) {
            this.index = index;
        }

        public int getValue() {
            return this.index;
        }

        public int hashCode() {
            return this.index;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DeviceIndex other = (DeviceIndex)obj;
            return this.index == other.index;
        }
    }

    public static final class Rotation {
        public static final Rotation DEG_0 = new Rotation(0);
        public static final Rotation DEG_90 = new Rotation(90);
        public static final Rotation DEG_180 = new Rotation(180);
        public static final Rotation DEG_270 = new Rotation(270);
        private final int angle;

        private Rotation(int angle) {
            this.angle = angle;
        }

        public int getAngle() {
            return this.angle;
        }

        public int hashCode() {
            return this.angle;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Rotation other = (Rotation)obj;
            return this.angle == other.angle;
        }
    }

    public static final class Dimension {
        private final int width;
        private final int height;

        public Dimension(int width, int height) {
            if (width < 1 || height < 1) {
                throw new IllegalArgumentException("Illegal dimensions");
            }
            this.width = width;
            this.height = height;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int hashCode() {
            int hash = 3;
            hash = 59 * hash + this.width;
            hash = 59 * hash + this.height;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Dimension other = (Dimension)obj;
            if (this.width != other.width) {
                return false;
            }
            return this.height == other.height;
        }
    }
}

