/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.praxislive.core.Port;
import org.praxislive.core.PortConnectionException;
import org.praxislive.core.PortListener;
import org.praxislive.video.VideoPort;
import org.praxislive.video.pipes.VideoPipe;
import org.praxislive.video.pipes.impl.MultiInOut;
import org.praxislive.video.render.Surface;
import org.praxislive.video.render.SurfaceOp;
import org.praxislive.video.render.ops.BlendMode;
import org.praxislive.video.render.ops.Blit;

public class DefaultVideoInputPort
extends VideoPort.Input {
    private static final Logger LOG = Logger.getLogger(DefaultVideoInputPort.class.getName());
    private static final int MAX_CONNECTIONS = 8;
    private final VideoPipe sink;
    private final List<VideoPort.Output> connections;
    private final List<PortListener> listeners;
    private VideoPipe portSink;
    private Mixer mixer;

    public DefaultVideoInputPort(VideoPipe sink) {
        if (sink == null) {
            throw new NullPointerException();
        }
        this.sink = sink;
        this.portSink = sink;
        this.connections = new ArrayList<VideoPort.Output>(8);
        this.listeners = new CopyOnWriteArrayList<PortListener>();
    }

    public void disconnectAll() {
        for (VideoPort.Output connection : this.connections()) {
            this.disconnect(connection);
        }
    }

    public List<VideoPort.Output> connections() {
        return List.copyOf(this.connections);
    }

    @Override
    protected void addVideoOutputPort(VideoPort.Output port, VideoPipe source) throws PortConnectionException {
        if (this.connections.contains(port)) {
            throw new PortConnectionException();
        }
        if (this.connections.size() == 1) {
            this.switchToMultichannel();
        }
        try {
            this.portSink.addSource(source);
            this.connections.add(port);
            this.listeners.forEach(l -> l.connectionsChanged((Port)this));
        }
        catch (Exception ex) {
            if (this.connections.size() == 1) {
                this.switchToSingleChannel();
            }
            throw new PortConnectionException();
        }
    }

    @Override
    protected void removeVideoOutputPort(VideoPort.Output port, VideoPipe source) {
        if (this.connections.remove(port)) {
            this.portSink.removeSource(source);
            if (this.connections.size() == 1) {
                this.switchToSingleChannel();
            }
            this.listeners.forEach(l -> l.connectionsChanged((Port)this));
        }
    }

    public void addListener(PortListener listener) {
        this.listeners.add(Objects.requireNonNull(listener));
    }

    public void removeListener(PortListener listener) {
        this.listeners.remove(listener);
    }

    private void switchToMultichannel() {
        if (this.portSink == this.mixer) {
            return;
        }
        LOG.fine("VideoInput switching to multichannel");
        VideoPipe[] sources = this.removeSources(this.sink);
        try {
            if (this.mixer == null) {
                this.mixer = new Mixer(8);
            }
            this.sink.addSource(this.mixer);
            for (VideoPipe source : sources) {
                this.mixer.addSource(source);
            }
            this.portSink = this.mixer;
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Error converting port to multi channel", ex);
            this.removeSources(this.mixer);
            this.removeSources(this.sink);
            this.connections.clear();
            this.listeners.forEach(l -> l.connectionsChanged((Port)this));
        }
    }

    private void switchToSingleChannel() {
        if (this.portSink == this.sink) {
            return;
        }
        LOG.fine("VideoInput switching to single channel");
        VideoPipe[] sources = this.removeSources(this.mixer);
        try {
            this.sink.removeSource(this.mixer);
            for (VideoPipe source : sources) {
                this.sink.addSource(source);
            }
            this.portSink = this.sink;
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Error converting port to single channel", ex);
            this.removeSources(this.sink);
            this.removeSources(this.mixer);
            this.connections.clear();
            this.listeners.forEach(l -> l.connectionsChanged((Port)this));
        }
    }

    private VideoPipe[] removeSources(VideoPipe sink) {
        VideoPipe[] sources = new VideoPipe[sink.getSourceCount()];
        for (int i = 0; i < sources.length; ++i) {
            sources[i] = sink.getSource(i);
        }
        for (VideoPipe source : sources) {
            sink.removeSource(source);
        }
        return sources;
    }

    private static class Mixer
    extends MultiInOut {
        private Blit blit = new Blit();

        private Mixer(int maxInputs) {
            super(maxInputs, 1);
            this.blit.setBlendMode(BlendMode.Add);
        }

        @Override
        protected void process(Surface[] inputs, Surface output, int index, boolean rendering) {
            if (!rendering) {
                return;
            }
            if (inputs.length == 0) {
                output.clear();
                return;
            }
            for (int i = 0; i < inputs.length; ++i) {
                Surface input = inputs[i];
                assert (input != output);
                if (i == 0) {
                    output.copy(input);
                } else {
                    output.process((SurfaceOp)this.blit, input);
                }
                input.release();
            }
        }
    }
}

