/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.praxislive.core.Port;
import org.praxislive.core.PortConnectionException;
import org.praxislive.core.PortListener;
import org.praxislive.video.VideoPort;
import org.praxislive.video.pipes.VideoPipe;
import org.praxislive.video.pipes.impl.MultiInOut;
import org.praxislive.video.render.Surface;

public class DefaultVideoOutputPort
extends VideoPort.Output {
    private static final Logger LOG = Logger.getLogger(DefaultVideoOutputPort.class.getName());
    private static final int MAX_CONNECTIONS = 8;
    private final VideoPipe source;
    private final List<VideoPort.Input> connections;
    private final List<PortListener> listeners;
    private VideoPipe portSource;
    private Splitter splitter;

    public DefaultVideoOutputPort(VideoPipe source) {
        if (source == null) {
            throw new NullPointerException();
        }
        this.source = source;
        this.portSource = source;
        this.connections = new ArrayList<VideoPort.Input>(8);
        this.listeners = new CopyOnWriteArrayList<PortListener>();
    }

    public void connect(Port port) throws PortConnectionException {
        if (port instanceof VideoPort.Input) {
            VideoPort.Input input = (VideoPort.Input)port;
            if (this.connections.contains(input)) {
                throw new PortConnectionException();
            }
            if (this.connections.size() == 1) {
                this.switchToMultichannel();
            }
            try {
                this.makeConnection(input, this.portSource);
                this.connections.add(input);
            }
            catch (PortConnectionException ex) {
                if (this.connections.size() == 1) {
                    this.switchToSingleChannel();
                }
                throw ex;
            }
        } else {
            throw new PortConnectionException();
        }
        this.listeners.forEach(l -> l.connectionsChanged((Port)this));
    }

    public void disconnect(Port port) {
        VideoPort.Input input;
        if (port instanceof VideoPort.Input && this.connections.contains(input = (VideoPort.Input)port)) {
            this.breakConnection(input, this.portSource);
            this.connections.remove(input);
            if (this.connections.size() == 1) {
                this.switchToSingleChannel();
            }
            this.listeners.forEach(l -> l.connectionsChanged((Port)this));
        }
    }

    public void disconnectAll() {
        for (VideoPort.Input port : this.connections()) {
            this.disconnect(port);
        }
    }

    public List<VideoPort.Input> connections() {
        return List.copyOf(this.connections);
    }

    public void addListener(PortListener listener) {
        this.listeners.add(Objects.requireNonNull(listener));
    }

    public void removeListener(PortListener listener) {
        this.listeners.remove(listener);
    }

    private void switchToMultichannel() {
        if (this.portSource == this.splitter) {
            return;
        }
        LOG.fine("VideoOutput switching to multichannel");
        VideoPipe[] sinks = this.removeSinks(this.source);
        try {
            if (this.splitter == null) {
                this.splitter = new Splitter(8);
            }
            this.splitter.addSource(this.source);
            for (VideoPipe sink : sinks) {
                sink.addSource(this.splitter);
            }
            this.portSource = this.splitter;
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Error converting port to multi channel", ex);
            this.removeSinks(this.splitter);
            this.removeSinks(this.source);
            this.portSource = this.source;
            this.connections.clear();
        }
    }

    private void switchToSingleChannel() {
        if (this.portSource == this.source) {
            return;
        }
        LOG.fine("VideoOutput switching to single channel");
        VideoPipe[] sinks = this.removeSinks(this.splitter);
        try {
            this.splitter.removeSource(this.source);
            for (VideoPipe sink : sinks) {
                sink.addSource(this.source);
            }
            this.portSource = this.source;
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Error converting port to single channel", ex);
            this.removeSinks(this.source);
            this.removeSinks(this.splitter);
            this.portSource = this.source;
            this.connections.clear();
        }
    }

    private VideoPipe[] removeSinks(VideoPipe source) {
        VideoPipe[] sinks = new VideoPipe[source.getSinkCount()];
        for (int i = 0; i < sinks.length; ++i) {
            sinks[i] = source.getSink(i);
        }
        for (VideoPipe sink : sinks) {
            sink.removeSource(source);
        }
        return sinks;
    }

    private static class Splitter
    extends MultiInOut {
        public Splitter(int maxOutputs) {
            super(1, maxOutputs);
        }

        @Override
        protected void process(Surface[] inputs, Surface output, int index, boolean rendering) {
            if (!rendering) {
                return;
            }
            if (inputs.length == 1) {
                Surface input = inputs[0];
                assert (input != output);
                output.copy(input);
            } else {
                output.clear();
            }
        }
    }
}

