/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video;

import java.util.stream.Stream;
import org.praxislive.core.Port;
import org.praxislive.core.PortConnectionException;
import org.praxislive.core.PortInfo;
import org.praxislive.core.types.PMap;
import org.praxislive.video.pipes.VideoPipe;

public abstract class VideoPort
implements Port {

    public static class Provider
    implements Port.TypeProvider {
        public Stream<Port.Type<?>> types() {
            return Stream.of(new Port.Type(VideoPort.class));
        }
    }

    public static abstract class Output
    extends VideoPort {
        private PortInfo info;

        public Output() {
            this(PMap.EMPTY);
        }

        public Output(PMap properties) {
            this.info = PortInfo.create(VideoPort.class, (PortInfo.Direction)PortInfo.Direction.OUT, (PMap)properties);
        }

        public final PortInfo getInfo() {
            return this.info;
        }

        protected final void makeConnection(Input port, VideoPipe source) throws PortConnectionException {
            port.addVideoOutputPort(this, source);
        }

        protected final void breakConnection(Input port, VideoPipe source) {
            port.removeVideoOutputPort(this, source);
        }
    }

    public static abstract class Input
    extends VideoPort {
        private PortInfo info;

        public Input() {
            this(PMap.EMPTY);
        }

        public Input(PMap properties) {
            this.info = PortInfo.create(VideoPort.class, (PortInfo.Direction)PortInfo.Direction.IN, (PMap)properties);
        }

        public final void connect(Port port) throws PortConnectionException {
            if (!(port instanceof Output)) {
                throw new PortConnectionException();
            }
            port.connect((Port)this);
        }

        public final void disconnect(Port port) {
            if (port instanceof Output) {
                port.disconnect((Port)this);
            }
        }

        public final PortInfo getInfo() {
            return this.info;
        }

        protected abstract void addVideoOutputPort(Output var1, VideoPipe var2) throws PortConnectionException;

        protected abstract void removeVideoOutputPort(Output var1, VideoPipe var2);
    }
}

