/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.pipes;

import org.praxislive.video.render.Surface;

public abstract class VideoPipe {
    public final void addSource(VideoPipe source) {
        source.registerSink(this);
        try {
            this.registerSource(source);
        }
        catch (RuntimeException ex) {
            source.unregisterSink(this);
            throw ex;
        }
    }

    public final void removeSource(VideoPipe source) {
        source.unregisterSink(this);
        this.unregisterSource(source);
    }

    public abstract int getSourceCount();

    public abstract int getSourceCapacity();

    public abstract VideoPipe getSource(int var1);

    public abstract int getSinkCount();

    public abstract int getSinkCapacity();

    public abstract VideoPipe getSink(int var1);

    protected final void callSource(VideoPipe source, Surface buffer, long time) {
        source.process(this, buffer, time);
    }

    protected final boolean sinkRequiresRender(VideoPipe sink, long time) {
        return sink.isRenderRequired(this, time);
    }

    protected abstract void process(VideoPipe var1, Surface var2, long var3);

    protected abstract boolean isRenderRequired(VideoPipe var1, long var2);

    protected abstract void registerSource(VideoPipe var1);

    protected abstract void unregisterSource(VideoPipe var1);

    protected abstract void registerSink(VideoPipe var1);

    protected abstract void unregisterSink(VideoPipe var1);
}

