/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.render.ops;

import org.praxislive.video.render.PixelData;
import org.praxislive.video.render.ops.BlendMode;
import org.praxislive.video.render.ops.RGBComposite;

class BlendUtil {
    BlendUtil() {
    }

    static void process(PixelData src, PixelData dst, BlendMode mode, double opacity) {
        RGBComposite cmp = BlendUtil.getComposite(mode);
        int alpha = BlendUtil.getExtraAlpha(opacity);
        int width = Math.min(src.getWidth(), dst.getWidth());
        int height = Math.min(src.getHeight(), dst.getHeight());
        int srcOffset = src.getOffset();
        int srcSL = src.getScanline();
        boolean srcAlpha = src.hasAlpha();
        int dstOffset = dst.getOffset();
        int dstSL = dst.getScanline();
        boolean dstAlpha = dst.hasAlpha();
        if (srcAlpha == dstAlpha) {
            if (dstAlpha) {
                BlendUtil.composeARGB(cmp, alpha, width, height, src.getData(), srcSL, srcOffset, dst.getData(), dstSL, dstOffset);
            } else {
                BlendUtil.composeRGB(cmp, alpha, width, height, src.getData(), srcSL, srcOffset, dst.getData(), dstSL, dstOffset);
            }
        } else {
            BlendUtil.composeMixed(cmp, alpha, width, height, src.getData(), srcSL, srcOffset, srcAlpha, dst.getData(), dstSL, dstOffset, dstAlpha);
        }
    }

    private static RGBComposite getComposite(BlendMode mode) {
        switch (mode) {
            case Add: {
                return RGBComposite.ADD;
            }
            case BitXor: {
                return RGBComposite.BITXOR;
            }
            case Difference: {
                return RGBComposite.DIFFERENCE;
            }
            case Mask: {
                return RGBComposite.MASK;
            }
            case Multiply: {
                return RGBComposite.MULTIPLY;
            }
            case Normal: {
                return RGBComposite.NORMAL;
            }
            case Screen: {
                return RGBComposite.SCREEN;
            }
            case Sub: {
                return RGBComposite.SUB;
            }
        }
        throw new IllegalArgumentException("Unknown blend mode");
    }

    private static int getExtraAlpha(double opacity) {
        if (opacity < 0.0 || opacity > 1.0) {
            throw new IllegalArgumentException("Opacity must be between 0 and 1");
        }
        return (int)Math.round(opacity * 255.0);
    }

    private static void composeRGB(RGBComposite cmp, int alpha, int width, int height, int[] srcData, int srcSL, int srcOffset, int[] dstData, int dstSL, int dstOffset) {
        if (srcSL == width && dstSL == width) {
            cmp.rgb(srcData, srcOffset, dstData, dstOffset, width * height, alpha);
        } else {
            for (int y = 0; y < height; ++y) {
                cmp.rgb(srcData, srcOffset, dstData, dstOffset, width, alpha);
                srcOffset += srcSL;
                dstOffset += dstSL;
            }
        }
    }

    private static void composeARGB(RGBComposite cmp, int alpha, int width, int height, int[] srcData, int srcSL, int srcOffset, int[] dstData, int dstSL, int dstOffset) {
        if (srcSL == width && dstSL == width) {
            cmp.argb(srcData, srcOffset, dstData, dstOffset, width * height, alpha);
        } else {
            for (int y = 0; y < height; ++y) {
                cmp.argb(srcData, srcOffset, dstData, dstOffset, width, alpha);
                srcOffset += srcSL;
                dstOffset += dstSL;
            }
        }
    }

    private static void composeMixed(RGBComposite cmp, int alpha, int width, int height, int[] srcData, int srcSL, int srcOffset, boolean srcAlpha, int[] dstData, int dstSL, int dstOffset, boolean dstAlpha) {
        int[] src = new int[width];
        int[] dst = new int[width];
        for (int y = 0; y < height; ++y) {
            int i;
            if (srcAlpha) {
                System.arraycopy(srcData, srcOffset, src, 0, width);
            } else {
                for (i = 0; i < width; ++i) {
                    src[i] = srcData[i + srcOffset] | 0xFF000000;
                }
            }
            if (dstAlpha) {
                System.arraycopy(dstData, dstOffset, dst, 0, width);
            } else {
                for (i = 0; i < width; ++i) {
                    dst[i] = dstData[i + dstOffset] | 0xFF000000;
                }
            }
            cmp.argb(src, 0, dst, 0, width, alpha);
            if (dstAlpha) {
                System.arraycopy(dst, 0, dstData, dstOffset, width);
            } else {
                for (i = 0; i < width; ++i) {
                    dstData[i + dstOffset] = dst[i] & 0xFFFFFF;
                }
            }
            srcOffset += srcSL;
            dstOffset += dstSL;
        }
    }
}

