/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.render.ops;

import org.praxislive.video.render.PixelData;
import org.praxislive.video.render.SurfaceOp;
import org.praxislive.video.render.utils.RGBMath;

public class Noise
implements SurfaceOp {
    private static final Noise op = new Noise();

    private Noise() {
    }

    @Override
    public void process(PixelData output, PixelData ... inputs) {
        int index = 0;
        int width = output.getWidth();
        int height = output.getHeight();
        int scanline = output.getScanline();
        int delta = scanline - width;
        int[] data = output.getData();
        boolean alpha = output.hasAlpha();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int value = RGBMath.random();
                data[index] = alpha ? value << 24 | value << 16 | value << 8 | value : value << 16 | value << 8 | value;
                ++index;
            }
            index += delta;
        }
    }

    public static SurfaceOp op() {
        return op;
    }
}

