/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.render.ops;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.Arrays;
import org.praxislive.video.render.PixelData;
import org.praxislive.video.render.SurfaceOp;
import org.praxislive.video.render.ops.BlendMode;
import org.praxislive.video.render.ops.BlendUtil;
import org.praxislive.video.render.ops.SubPixels;
import org.praxislive.video.render.ops.TempData;
import org.praxislive.video.render.utils.RGBMath;

public class RectFill
implements SurfaceOp {
    private final Rectangle bounds = new Rectangle();
    private Color color = new Color(0, 0, 0, 0);
    private BlendMode blendMode = BlendMode.Normal;
    private double opacity = 1.0;

    public RectFill setBounds(int x, int y, int width, int height) {
        this.bounds.setBounds(x, y, width, height);
        return this;
    }

    public RectFill setBounds(Rectangle rect) {
        this.bounds.setBounds(rect);
        return this;
    }

    public Rectangle getBounds(Rectangle rect) {
        if (rect == null) {
            return new Rectangle(this.bounds);
        }
        rect.setBounds(this.bounds);
        return rect;
    }

    public RectFill setColor(Color color) {
        if (color == null) {
            throw new NullPointerException();
        }
        this.color = color;
        return this;
    }

    public Color getColor() {
        return this.color;
    }

    public RectFill setBlendMode(BlendMode blendMode) {
        if (blendMode == null) {
            throw new NullPointerException();
        }
        this.blendMode = blendMode;
        return this;
    }

    public BlendMode getBlendMode() {
        return this.blendMode;
    }

    public RectFill setOpacity(double opacity) {
        if (opacity < 0.0) {
            opacity = 0.0;
        } else if (opacity > 1.0) {
            opacity = 1.0;
        }
        this.opacity = opacity;
        return this;
    }

    public double getOpacity() {
        return this.opacity;
    }

    @Override
    public void process(PixelData output, PixelData ... inputs) {
        Rectangle out = new Rectangle(output.getWidth(), output.getHeight());
        Rectangle intersection = out.intersection(this.bounds);
        if (intersection.isEmpty()) {
            return;
        }
        boolean forceAlpha = false;
        int alpha = this.color.getAlpha();
        if (alpha == 0) {
            return;
        }
        if (alpha < 255) {
            forceAlpha = true;
        }
        int c = RGBMath.premultiply(this.color.getRGB());
        TempData tmp = TempData.create(intersection.width, intersection.height, forceAlpha || output.hasAlpha());
        Arrays.fill(tmp.getData(), 0, intersection.width * intersection.height, c);
        SubPixels dst = SubPixels.create(output, intersection);
        BlendUtil.process(tmp, dst, this.blendMode, this.opacity);
        tmp.release();
    }
}

