/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.render.ops;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.praxislive.video.render.PixelData;
import org.praxislive.video.render.SurfaceOp;
import org.praxislive.video.render.ops.BlendMode;
import org.praxislive.video.render.ops.BlendUtil;
import org.praxislive.video.render.ops.SubPixels;
import org.praxislive.video.render.ops.TempData;
import org.praxislive.video.render.utils.ImageUtils;

public class ShapeRender
implements SurfaceOp {
    private static final double EPSILON = 0.997;
    private Shape shape;
    private AffineTransform transform;
    private BasicStroke stroke;
    private BlendMode blendMode = BlendMode.Normal;
    private double opacity = 1.0;
    private Color fillColor;
    private Color strokeColor;

    public ShapeRender setShape(Shape shape) {
        this.shape = shape;
        return this;
    }

    public Shape getShape() {
        return this.shape;
    }

    public ShapeRender setStroke(BasicStroke stroke) {
        this.stroke = stroke;
        return this;
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    public BlendMode getBlendMode() {
        return this.blendMode;
    }

    public ShapeRender setBlendMode(BlendMode blendMode) {
        if (blendMode == null) {
            throw new NullPointerException();
        }
        this.blendMode = blendMode;
        return this;
    }

    public double getOpacity() {
        return this.opacity;
    }

    public ShapeRender setOpacity(double opacity) {
        if (opacity < 0.0) {
            opacity = 0.0;
        } else if (opacity > 1.0) {
            opacity = 1.0;
        }
        this.opacity = opacity;
        return this;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public ShapeRender setFillColor(Color fillColor) {
        this.fillColor = fillColor;
        return this;
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public ShapeRender setStrokeColor(Color strokeColor) {
        this.strokeColor = strokeColor;
        return this;
    }

    public ShapeRender setTransform(AffineTransform transform) {
        this.transform = transform;
        return this;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    @Override
    public void process(PixelData output, PixelData ... inputs) {
        if (this.shape == null) {
            return;
        }
        if (this.blendMode == BlendMode.Normal) {
            this.processDirect(output);
        } else {
            this.processIndirect(output);
        }
    }

    private void processDirect(PixelData output) {
        BufferedImage im = ImageUtils.toImage(output);
        Graphics2D g2d = im.createGraphics();
        if (this.opacity < 0.997) {
            g2d.setComposite(AlphaComposite.SrcOver.derive((float)this.opacity));
        }
        this.drawShape(g2d, this.transform == null ? this.shape : this.transform.createTransformedShape(this.shape));
    }

    private void processIndirect(PixelData output) {
        Shape sh = this.transform == null ? this.shape : this.transform.createTransformedShape(this.shape);
        Rectangle sRct = sh.getBounds();
        if (this.stroke != null) {
            int growth = Math.round(this.stroke.getLineWidth());
            sRct.grow(growth, growth);
        }
        int tx = sRct.x > 0 ? -sRct.x : 0;
        int ty = sRct.y > 0 ? -sRct.y : 0;
        Rectangle dRct = new Rectangle(0, 0, output.getWidth(), output.getHeight());
        Rectangle intersection = dRct.intersection(sRct);
        if (intersection.isEmpty()) {
            return;
        }
        TempData tmp = TempData.create(intersection.width, intersection.height, true);
        BufferedImage bi = ImageUtils.toImage(tmp);
        Graphics2D g2d = bi.createGraphics();
        g2d.translate(tx, ty);
        this.drawShape(g2d, sh);
        SubPixels dst = SubPixels.create(output, intersection);
        BlendUtil.process(tmp, dst, this.blendMode, this.opacity);
        tmp.release();
    }

    private void drawShape(Graphics2D g2d, Shape sh) {
        if (this.fillColor != null) {
            g2d.setColor(this.fillColor);
            g2d.fill(sh);
        }
        if (this.stroke != null && this.strokeColor != null) {
            g2d.setStroke(this.stroke);
            g2d.setColor(this.strokeColor);
            g2d.draw(sh);
        }
    }
}

