/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.render.ops;

import java.awt.Rectangle;
import org.praxislive.video.render.PixelData;
import org.praxislive.video.render.SurfaceOp;
import org.praxislive.video.render.ops.Bounds;
import org.praxislive.video.render.ops.SubPixels;

public class Sub
implements SurfaceOp {
    private Bounds bounds;
    private SurfaceOp op;

    private Sub(Bounds bounds, SurfaceOp op) {
        this.bounds = bounds;
        this.op = op;
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public SurfaceOp getOp() {
        return this.op;
    }

    @Override
    public void process(PixelData output, PixelData ... inputs) {
        Rectangle bnds = this.bounds.asRectangle();
        Rectangle out = new Rectangle(output.getWidth(), output.getHeight());
        bnds = out.intersection(bnds);
        if (bnds.isEmpty()) {
            return;
        }
        this.op.process(SubPixels.create(output, bnds), inputs);
    }

    public static SurfaceOp op(SurfaceOp op, Bounds bounds) {
        if (bounds == null || op == null) {
            throw new NullPointerException();
        }
        return new Sub(bounds, op);
    }

    public static SurfaceOp op(SurfaceOp op, int x, int y, int width, int height) {
        return Sub.op(op, new Bounds(x, y, width, height));
    }
}

