/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.render.ops;

import java.awt.Rectangle;
import org.praxislive.video.render.PixelData;

class SubPixels
implements PixelData {
    private PixelData pd;
    private int x;
    private int y;
    private int width;
    private int height;

    private SubPixels(PixelData pd, int x, int y, int width, int height) {
        this.pd = pd;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    @Override
    public int[] getData() {
        return this.pd.getData();
    }

    @Override
    public int getOffset() {
        return this.pd.getOffset() + this.y * this.pd.getScanline() + this.x;
    }

    @Override
    public int getScanline() {
        return this.pd.getScanline();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean hasAlpha() {
        return this.pd.hasAlpha();
    }

    public static SubPixels create(PixelData pd, int x, int y, int width, int height) {
        if (x < 0 || y < 0) {
            throw new IllegalArgumentException();
        }
        if (x + width > pd.getWidth() || y + height > pd.getHeight()) {
            throw new IllegalArgumentException();
        }
        return new SubPixels(pd, x, y, width, height);
    }

    public static SubPixels create(PixelData pd, Rectangle bnds) {
        return SubPixels.create(pd, bnds.x, bnds.y, bnds.width, bnds.height);
    }
}

