/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.render.ops;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.praxislive.video.render.PixelData;
import org.praxislive.video.render.SurfaceOp;
import org.praxislive.video.render.utils.ImageUtils;

public class TextRender
implements SurfaceOp {
    private String text = "";
    private Font font;
    private Color color = Color.WHITE;
    private double x = 0.0;
    private double y = 0.0;
    private AffineTransform transform;

    public String getText() {
        return this.text;
    }

    public TextRender setText(String text) {
        if (text == null) {
            text = "";
        }
        this.text = text;
        return this;
    }

    public Font getFont() {
        return this.font;
    }

    public TextRender setFont(Font font) {
        this.font = font;
        return this;
    }

    public Color getColor() {
        return this.color;
    }

    public TextRender setColor(Color color) {
        if (color == null) {
            color = Color.WHITE;
        }
        this.color = color;
        return this;
    }

    public double getX() {
        return this.x;
    }

    public TextRender setX(double x) {
        this.x = x;
        return this;
    }

    public double getY() {
        return this.y;
    }

    public TextRender setY(double y) {
        this.y = y;
        return this;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public TextRender setTransform(AffineTransform transform) {
        this.transform = transform;
        return this;
    }

    @Override
    public void process(PixelData output, PixelData ... inputs) {
        if (this.text == null || this.text.isEmpty() || this.font == null) {
            return;
        }
        BufferedImage im = ImageUtils.toImage(output);
        Graphics2D g = im.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.transform != null) {
            g.setTransform(this.transform);
        }
        g.setColor(this.color);
        g.setFont(this.font);
        g.drawString(this.text, (float)this.x, (float)this.y);
    }
}

