/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.video.render.rgbmath;

import org.praxislive.video.render.rgbmath.RGBSinglePixelFilter;
import org.praxislive.video.render.utils.RGBMath;

public class InvertValueRGBFilter
implements RGBSinglePixelFilter {
    private static InvertValueRGBFilter instance = new InvertValueRGBFilter();

    private InvertValueRGBFilter() {
    }

    @Override
    public void filterRGB(int[] src, int srcPos, int[] dest, int destPos, int length) {
        for (int i = 0; i < length; ++i) {
            int min;
            int value;
            int pix = src[srcPos];
            int a = pix & 0xFF000000;
            int r = (pix & 0xFF0000) >>> 16;
            int g = (pix & 0xFF00) >>> 8;
            int b = pix & 0xFF;
            if (r > g) {
                value = RGBMath.max(r, b);
                min = RGBMath.min(g, b);
            } else {
                value = RGBMath.max(g, b);
                min = RGBMath.min(r, b);
            }
            int delta = value - min;
            if (value == 0 || delta == 0) {
                r = 255 - value;
                g = 255 - value;
                b = 255 - value;
            } else {
                int value2 = value / 2;
                if (r == value) {
                    r = 255 - r;
                    b = (r * b + value2) / value;
                    g = (r * g + value2) / value;
                } else if (g == value) {
                    g = 255 - g;
                    r = (g * r + value2) / value;
                    b = (g * b + value2) / value;
                } else {
                    b = 255 - b;
                    r = (b * r + value2) / value;
                    g = (b * g + value2) / value;
                }
            }
            dest[destPos] = a | r << 16 | g << 8 | b;
            ++srcPos;
            ++destPos;
        }
    }

    @Override
    public void filterARGB(int[] src, int srcPos, int[] dest, int destPos, int length) {
        for (int i = 0; i < length; ++i) {
            int min;
            int value;
            int pix = src[srcPos];
            int a = (pix & 0xFF000000) >>> 24;
            int r = (pix & 0xFF0000) >>> 16;
            int g = (pix & 0xFF00) >>> 8;
            int b = pix & 0xFF;
            if (r > g) {
                value = RGBMath.max(r, b);
                min = RGBMath.min(g, b);
            } else {
                value = RGBMath.max(g, b);
                min = RGBMath.min(r, b);
            }
            int delta = value - min;
            if (value == 0 || delta == 0) {
                r = 255 - value;
                g = 255 - value;
                b = 255 - value;
            } else {
                int value2 = value / 2;
                if (r == value) {
                    r = RGBMath.max(255 - r, a);
                    b = RGBMath.max((r * b + value2) / value, a);
                    g = RGBMath.max((r * g + value2) / value, a);
                } else if (g == value) {
                    g = RGBMath.max(255 - g, a);
                    r = RGBMath.max((g * r + value2) / value, a);
                    b = RGBMath.max((g * b + value2) / value, a);
                } else {
                    b = RGBMath.max(255 - b, a);
                    r = RGBMath.max((b * r + value2) / value, a);
                    g = RGBMath.max((b * g + value2) / value, a);
                }
            }
            dest[destPos] = a << 24 | r << 16 | g << 8 | b;
            ++srcPos;
            ++destPos;
        }
    }

    public static InvertValueRGBFilter getInstance() {
        return instance;
    }
}

